/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.impl.textparser.providers;

import com.mojang.serialization.DataResult;
import eu.pb4.placeholders.api.arguments.StringArgs;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.node.parent.ColorNode;
import eu.pb4.placeholders.api.parsers.TagLikeParser;
import eu.pb4.placeholders.api.parsers.tag.TagRegistry;
import eu.pb4.placeholders.api.parsers.tag.TextTag;
import net.minecraft.network.chat.TextColor;

public record LenientProvider(TagRegistry registry) implements TagLikeParser.Provider
{
    @Override
    public boolean isValidTag(String tag, TagLikeParser.Context context) {
        return tag.equals("/*") || tag.startsWith("#") || tag.equals("r") || tag.equals("reset") || this.registry.getTag(tag) != null || tag.equals("/") || tag.length() > 1 && tag.charAt(0) == '/' && context.contains(tag.substring(1)) || tag.length() > 1 && tag.charAt(0) == ';' && context.contains(tag.substring(1));
    }

    @Override
    public void handleTag(String id, String argument, TagLikeParser.Context context) {
        String peek = context.peekId();
        if (id.equals("/") || peek != null && (id.equals("/" + peek) || peek.startsWith("#") && id.equals("/c"))) {
            context.pop();
            return;
        }
        if (id.equals("/*") || id.equals("r") || id.equals("reset")) {
            context.pop(context.size());
            return;
        }
        if (id.length() > 1 && id.charAt(0) == '/') {
            String s = id.substring(1);
            context.popInclusive(x -> x.equals(s));
            return;
        }
        if (id.length() > 1 && id.charAt(0) == ';') {
            String s = id.substring(1);
            context.popOnly(s);
            return;
        }
        if (id.startsWith("#")) {
            DataResult text = TextColor.parseColor((String)id);
            if (text.result().isPresent()) {
                context.push(id, x -> new ColorNode((TextNode[])x, (TextColor)text.result().get()));
            }
            return;
        }
        TextTag tag = this.registry.getTag(id);
        assert (tag != null);
        StringArgs args = argument.isEmpty() ? StringArgs.empty() : (context.input().charAt(context.currentTagPos() + id.length() + 1) == ':' ? StringArgs.ordered(argument, ':') : StringArgs.full(argument, ' ', ':'));
        if (tag.selfContained()) {
            context.addNode(tag.nodeCreator().createTextNode(TextNode.array(new TextNode[0]), args, context.parser()));
        } else {
            context.push(id, a -> tag.nodeCreator().createTextNode((TextNode[])a, args, context.parser()));
        }
    }
}

