/*
 * Decompiled with CFR 0.152.
 */
package tn.mbs.memory.configuration;

import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;

public class MainConfigFileConfiguration {
    public static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec SPEC;
    public static final ModConfigSpec.ConfigValue<Double> LEVEL_PER_ORB;
    public static final ModConfigSpec.ConfigValue<Double> SCALE_FACTOR;
    public static final ModConfigSpec.ConfigValue<Double> POINTS_PER_LEVEL;
    public static final ModConfigSpec.ConfigValue<Boolean> USE_VANILLA_XP;
    public static final ModConfigSpec.ConfigValue<Boolean> ON_DEATH_RESET;
    public static final ModConfigSpec.ConfigValue<Double> MAX_PLAYER_LEVEL;
    public static final ModConfigSpec.ConfigValue<List<? extends String>> LEVELS_SCALE_INTERVAL;
    public static final ModConfigSpec.ConfigValue<Double> DEFAULT_LEVELING_SCALE;
    public static final ModConfigSpec.ConfigValue<Double> FIRST_LEVEL_VP;
    public static final ModConfigSpec.ConfigValue<Boolean> SHOW_VP_INACTION_BAR;
    public static final ModConfigSpec.ConfigValue<Boolean> DISPLAY_LEVEL;
    public static final ModConfigSpec.ConfigValue<Boolean> DISPLAY_VP;
    public static final ModConfigSpec.ConfigValue<Boolean> DISPLAY_POINTS;
    public static final ModConfigSpec.ConfigValue<String> GLOBAL_STATS_UI_COLOR;

    static {
        BUILDER.push("Global Settings");
        LEVEL_PER_ORB = BUILDER.define("level_per_orb", (Object)1.0);
        SCALE_FACTOR = BUILDER.define("vp_diminishing_factor", (Object)20.0);
        POINTS_PER_LEVEL = BUILDER.define("points_per_level", (Object)1.0);
        USE_VANILLA_XP = BUILDER.define("use_vanilla_xp", false);
        ON_DEATH_RESET = BUILDER.define("on_death_reset", false);
        MAX_PLAYER_LEVEL = BUILDER.define("max_player_level", (Object)500.0);
        BUILDER.pop();
        BUILDER.push("Leveling Scale");
        LEVELS_SCALE_INTERVAL = BUILDER.comment("levels_scale_interval").defineList("levels_scale_interval", List.of("[range]0-50[rangeEnd][scale]1.1[scaleEnd]", "[range]51-100[rangeEnd][scale]1.05[scaleEnd]", "[range]101-200[rangeEnd][scale]1.01[scaleEnd]", "[range]201-500[rangeEnd][scale]1.001[scaleEnd]"), entry -> true);
        DEFAULT_LEVELING_SCALE = BUILDER.define("levels_scale_default", (Object)1.001);
        FIRST_LEVEL_VP = BUILDER.define("first_level_vp", (Object)90.0);
        BUILDER.pop();
        BUILDER.push("HUD Overlay");
        SHOW_VP_INACTION_BAR = BUILDER.define("show_vp_inaction_bar", true);
        DISPLAY_LEVEL = BUILDER.define("display_level_overlay", true);
        DISPLAY_VP = BUILDER.define("display_vp_overlay", true);
        DISPLAY_POINTS = BUILDER.define("display_points_overlay", true);
        GLOBAL_STATS_UI_COLOR = BUILDER.define("global_stats_ui_color", (Object)"\u00a76");
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

