/*
 * Decompiled with CFR 0.152.
 */
package tn.mbs.memory.network;

import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import tn.mbs.memory.MemoryOfThePastMod;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class MemoryOfThePastModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"memory_of_the_past");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        MemoryOfThePastMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"memory_of_the_past", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public double attribute_1 = 20.0;
        public double attribute_6 = 0.0;
        public double attribute_5 = 0.1;
        public double attribute_2 = 2.0;
        public double attribute_4 = 0.0;
        public double attribute_3 = 4.0;
        public double Level = 0.0;
        public double SparePoints = 1.0;
        public double currentXpTLevel = 0.0;
        public double nextevelXp = 100.0;
        public double attribute_7 = 0.0;
        public double attribute_8 = 0.0;
        public double attribute_9 = 0.0;
        public double attribute_10 = 0.0;
        public double modifier = 1.0;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putDouble("attribute_1", this.attribute_1);
            nbt.putDouble("attribute_6", this.attribute_6);
            nbt.putDouble("attribute_5", this.attribute_5);
            nbt.putDouble("attribute_2", this.attribute_2);
            nbt.putDouble("attribute_4", this.attribute_4);
            nbt.putDouble("attribute_3", this.attribute_3);
            nbt.putDouble("Level", this.Level);
            nbt.putDouble("SparePoints", this.SparePoints);
            nbt.putDouble("currentXpTLevel", this.currentXpTLevel);
            nbt.putDouble("nextevelXp", this.nextevelXp);
            nbt.putDouble("attribute_7", this.attribute_7);
            nbt.putDouble("attribute_8", this.attribute_8);
            nbt.putDouble("attribute_9", this.attribute_9);
            nbt.putDouble("attribute_10", this.attribute_10);
            nbt.putDouble("modifier", this.modifier);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.attribute_1 = nbt.getDouble("attribute_1");
            this.attribute_6 = nbt.getDouble("attribute_6");
            this.attribute_5 = nbt.getDouble("attribute_5");
            this.attribute_2 = nbt.getDouble("attribute_2");
            this.attribute_4 = nbt.getDouble("attribute_4");
            this.attribute_3 = nbt.getDouble("attribute_3");
            this.Level = nbt.getDouble("Level");
            this.SparePoints = nbt.getDouble("SparePoints");
            this.currentXpTLevel = nbt.getDouble("currentXpTLevel");
            this.nextevelXp = nbt.getDouble("nextevelXp");
            this.attribute_7 = nbt.getDouble("attribute_7");
            this.attribute_8 = nbt.getDouble("attribute_8");
            this.attribute_9 = nbt.getDouble("attribute_9");
            this.attribute_10 = nbt.getDouble("attribute_10");
            this.modifier = nbt.getDouble("modifier");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.attribute_1 = original.attribute_1;
            clone.attribute_6 = original.attribute_6;
            clone.attribute_5 = original.attribute_5;
            clone.attribute_2 = original.attribute_2;
            clone.attribute_4 = original.attribute_4;
            clone.attribute_3 = original.attribute_3;
            clone.Level = original.Level;
            clone.SparePoints = original.SparePoints;
            clone.currentXpTLevel = original.currentXpTLevel;
            clone.nextevelXp = original.nextevelXp;
            clone.attribute_7 = original.attribute_7;
            clone.attribute_8 = original.attribute_8;
            clone.attribute_9 = original.attribute_9;
            clone.attribute_10 = original.attribute_10;
            clone.modifier = original.modifier;
            if (!event.isWasDeath()) {
                // empty if block
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }
    }
}

