/*
 * Decompiled with CFR 0.152.
 */
package tn.mbs.memory.network;

import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import tn.mbs.memory.MemoryOfThePastMod;
import tn.mbs.memory.procedures.AddModiferCountProcedure;
import tn.mbs.memory.procedures.AddPointsAttributeEightProcedure;
import tn.mbs.memory.procedures.AddPointsAttributeFifthProcedure;
import tn.mbs.memory.procedures.AddPointsAttributeForthProcedure;
import tn.mbs.memory.procedures.AddPointsAttributeNineProcedure;
import tn.mbs.memory.procedures.AddPointsAttributeOneProcedure;
import tn.mbs.memory.procedures.AddPointsAttributeSeventhProcedure;
import tn.mbs.memory.procedures.AddPointsAttributeSixthProcedure;
import tn.mbs.memory.procedures.AddPointsAttributeTenProcedure;
import tn.mbs.memory.procedures.AddPointsAttributeThreeProcedure;
import tn.mbs.memory.procedures.AddPointsAttributeTwoProcedure;
import tn.mbs.memory.procedures.OpenAttributesDisplayGUIProcedure;
import tn.mbs.memory.procedures.RemoveModiferCountProcedure;
import tn.mbs.memory.world.inventory.PlayerStatsGUIMenu;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record PlayerStatsGUIButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PlayerStatsGUIButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"memory_of_the_past", (String)"player_stats_gui_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PlayerStatsGUIButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new PlayerStatsGUIButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<PlayerStatsGUIButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(PlayerStatsGUIButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                PlayerStatsGUIButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = PlayerStatsGUIMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            AddPointsAttributeOneProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            AddPointsAttributeTwoProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            AddPointsAttributeThreeProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            AddPointsAttributeForthProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            AddPointsAttributeFifthProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            AddPointsAttributeSixthProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            AddPointsAttributeSeventhProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            AddPointsAttributeEightProcedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            AddPointsAttributeNineProcedure.execute((Entity)entity);
        }
        if (buttonID == 9) {
            AddPointsAttributeTenProcedure.execute((Entity)entity);
        }
        if (buttonID == 10) {
            OpenAttributesDisplayGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 11) {
            RemoveModiferCountProcedure.execute((Entity)entity);
        }
        if (buttonID == 12) {
            AddModiferCountProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MemoryOfThePastMod.addNetworkMessage(TYPE, STREAM_CODEC, PlayerStatsGUIButtonMessage::handleData);
    }
}

