/*
 * Decompiled with CFR 0.152.
 */
package tn.naizo.jauml;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.neoforged.fml.loading.FMLPaths;

public class JaumlConfigLib {
    private static final Logger LOGGER = Logger.getLogger("JaumlConfigLib");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static boolean createConfigFile(String dir, String fileName) {
        if (!((String)fileName).endsWith(".json")) {
            fileName = (String)fileName + ".json";
        }
        File configDir = FMLPaths.CONFIGDIR.get().resolve(dir).toFile();
        File configFile = new File(configDir, (String)fileName);
        if (!configDir.exists()) {
            configDir.mkdirs();
        } else {
            LOGGER.log(Level.FINE, "Config directory already exists: {0}", configDir.getPath());
        }
        if (configFile.exists()) {
            return true;
        }
        try {
            return configFile.createNewFile();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to create config file: {0}", configFile.getPath());
            LOGGER.log(Level.SEVERE, "Exception: {0}", e.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean stringExistsInArray(String dir, String fileName, String arrayKey, String targetString) {
        File configFile;
        if (!((String)fileName).endsWith(".json")) {
            fileName = (String)fileName + ".json";
        }
        if (!(configFile = FMLPaths.CONFIGDIR.get().resolve(dir).resolve((String)fileName).toFile()).exists()) {
            return false;
        }
        try (FileReader reader = new FileReader(configFile);){
            JsonElement item;
            JsonObject root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (root == null) return false;
            if (!root.has(arrayKey)) return false;
            JsonElement element = root.get(arrayKey);
            if (!element.isJsonArray()) return false;
            JsonArray array = element.getAsJsonArray();
            Iterator iterator = array.iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while (!(item = (JsonElement)iterator.next()).isJsonPrimitive() || !item.getAsString().equals(targetString));
            boolean bl = true;
            return bl;
        }
        catch (JsonParseException | IOException e) {
            LOGGER.log(Level.SEVERE, "Error reading or parsing config file: {0}", e.getMessage());
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean arrayKeyExists(String dir, String fileName, String key) {
        File configFile;
        if (!((String)fileName).endsWith(".json")) {
            fileName = (String)fileName + ".json";
        }
        if (!(configFile = FMLPaths.CONFIGDIR.get().resolve(dir).resolve((String)fileName).toFile()).exists()) {
            return false;
        }
        try (FileReader reader = new FileReader(configFile);){
            JsonObject root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (root == null) return false;
            boolean bl = root.has(key);
            return bl;
        }
        catch (JsonParseException | IOException e) {
            LOGGER.log(Level.SEVERE, "Error reading or parsing config file: {0}", e.getMessage());
        }
        return false;
    }

    public static boolean addStringToArray(String dir, String fileName, String arrayKey, String stringToAdd) {
        boolean bl;
        JsonArray array;
        if (!((String)fileName).endsWith(".json")) {
            fileName = (String)fileName + ".json";
        }
        File configFile = FMLPaths.CONFIGDIR.get().resolve(dir).resolve((String)fileName).toFile();
        JsonObject root = new JsonObject();
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                if (root == null) {
                    root = new JsonObject();
                }
            }
            catch (JsonParseException | IOException e) {
                return false;
            }
        }
        if (root.has(arrayKey) && root.get(arrayKey).isJsonArray()) {
            array = root.getAsJsonArray(arrayKey);
        } else {
            array = new JsonArray();
            root.add(arrayKey, (JsonElement)array);
        }
        for (JsonElement element : array) {
            if (!element.isJsonPrimitive() || !element.getAsString().equals(stringToAdd)) continue;
            return false;
        }
        array.add(stringToAdd);
        FileWriter writer = new FileWriter(configFile);
        try {
            GSON.toJson((JsonElement)root, (Appendable)writer);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        writer.close();
        return bl;
    }

    public static boolean configFileExists(String dir, String fileName) {
        if (!((String)fileName).endsWith(".json")) {
            fileName = (String)fileName + ".json";
        }
        File configFile = FMLPaths.CONFIGDIR.get().resolve(dir).resolve((String)fileName).toFile();
        return configFile.exists();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getArrayLength(String dir, String fileName, String arrayKey) {
        File configFile;
        if (!((String)fileName).endsWith(".json")) {
            fileName = (String)fileName + ".json";
        }
        if (!(configFile = FMLPaths.CONFIGDIR.get().resolve(dir).resolve((String)fileName).toFile()).exists()) {
            return 0;
        }
        try (FileReader reader = new FileReader(configFile);){
            JsonObject root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (root == null) return 0;
            if (!root.has(arrayKey)) return 0;
            JsonElement element = root.get(arrayKey);
            if (!element.isJsonArray()) return 0;
            int n = element.getAsJsonArray().size();
            return n;
        }
        catch (JsonParseException | IOException e) {
            LOGGER.log(Level.SEVERE, "Error reading or parsing config file: {0}", e.getMessage());
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getArrayElement(String dir, String fileName, String arrayKey, int index) {
        File configFile;
        if (!((String)fileName).endsWith(".json")) {
            fileName = (String)fileName + ".json";
        }
        if (!(configFile = FMLPaths.CONFIGDIR.get().resolve(dir).resolve((String)fileName).toFile()).exists()) {
            return null;
        }
        try (FileReader reader = new FileReader(configFile);){
            JsonObject root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (root == null) return null;
            if (!root.has(arrayKey)) return null;
            JsonElement element = root.get(arrayKey);
            if (!element.isJsonArray()) return null;
            JsonArray array = element.getAsJsonArray();
            if (index < 0) return null;
            if (index >= array.size()) return null;
            JsonElement item = array.get(index);
            if (!item.isJsonPrimitive()) return null;
            String string = item.getAsString();
            return string;
        }
        catch (JsonParseException | IOException e) {
            LOGGER.log(Level.SEVERE, "Error reading or parsing config file: {0}", e.getMessage());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getStringValue(String dir, String fileName, String key) {
        File configFile;
        if (!((String)fileName).endsWith(".json")) {
            fileName = (String)fileName + ".json";
        }
        if (!(configFile = FMLPaths.CONFIGDIR.get().resolve(dir).resolve((String)fileName).toFile()).exists()) {
            return null;
        }
        try (FileReader reader = new FileReader(configFile);){
            JsonObject root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (root == null) return null;
            if (!root.has(key)) return null;
            JsonElement element = root.get(key);
            if (!element.isJsonPrimitive()) return null;
            if (!element.getAsJsonPrimitive().isString()) return null;
            String string = element.getAsString();
            return string;
        }
        catch (JsonParseException | IOException e) {
            LOGGER.log(Level.SEVERE, "Error reading or parsing config file: {0}", e.getMessage());
        }
        return null;
    }

    /*
     * Loose catch block
     */
    public static double getNumberValue(String dir, String fileName, String key) {
        block10: {
            FileReader reader;
            block9: {
                JsonElement element;
                File configFile;
                if (!((String)fileName).endsWith(".json")) {
                    fileName = (String)fileName + ".json";
                }
                if (!(configFile = FMLPaths.CONFIGDIR.get().resolve(dir).resolve((String)fileName).toFile()).exists()) {
                    return 0.0;
                }
                reader = new FileReader(configFile);
                JsonObject root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                if (root == null || !root.has(key) || !(element = root.get(key)).isJsonPrimitive() || !element.getAsJsonPrimitive().isNumber()) break block9;
                double d = element.getAsNumber().doubleValue();
                reader.close();
                return d;
            }
            try {
                reader.close();
                break block10;
                {
                    catch (Throwable throwable) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            }
            catch (JsonParseException | IOException e) {
                LOGGER.log(Level.SEVERE, "Error reading or parsing config file: {0}", e.getMessage());
            }
        }
        return 0.0;
    }

    public static boolean setStringValue(String dir, String fileName, String key, String value) {
        boolean bl;
        File configFile;
        if (!((String)fileName).endsWith(".json")) {
            fileName = (String)fileName + ".json";
        }
        if (!(configFile = FMLPaths.CONFIGDIR.get().resolve(dir).resolve((String)fileName).toFile()).exists() && !JaumlConfigLib.createConfigFile(dir, (String)fileName)) {
            LOGGER.log(Level.SEVERE, "Failed to create config file: {0}", configFile.getPath());
            return false;
        }
        JsonObject root = new JsonObject();
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                if (root == null) {
                    root = new JsonObject();
                }
            }
            catch (JsonParseException | IOException e) {
                LOGGER.log(Level.SEVERE, "Error reading or parsing config file: {0}", e.getMessage());
                return false;
            }
        }
        root.addProperty(key, value);
        FileWriter writer = new FileWriter(configFile);
        try {
            GSON.toJson((JsonElement)root, (Appendable)writer);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Error writing to config file: {0}", e.getMessage());
                return false;
            }
        }
        writer.close();
        return bl;
    }

    public static boolean setNumberValue(String dir, String fileName, String key, double value) {
        boolean bl;
        File configFile;
        if (!((String)fileName).endsWith(".json")) {
            fileName = (String)fileName + ".json";
        }
        if (!(configFile = FMLPaths.CONFIGDIR.get().resolve(dir).resolve((String)fileName).toFile()).exists() && !JaumlConfigLib.createConfigFile(dir, (String)fileName)) {
            LOGGER.log(Level.SEVERE, "Failed to create config file: {0}", configFile.getPath());
            return false;
        }
        JsonObject root = new JsonObject();
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                if (root == null) {
                    root = new JsonObject();
                }
            }
            catch (JsonParseException | IOException e) {
                LOGGER.log(Level.SEVERE, "Error reading or parsing config file: {0}", e.getMessage());
                return false;
            }
        }
        root.addProperty(key, (Number)value);
        FileWriter writer = new FileWriter(configFile);
        try {
            GSON.toJson((JsonElement)root, (Appendable)writer);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Error writing to config file: {0}", e.getMessage());
                return false;
            }
        }
        writer.close();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean getBooleanValue(String dir, String fileName, String key) {
        File configFile;
        if (!((String)fileName).endsWith(".json")) {
            fileName = (String)fileName + ".json";
        }
        if (!(configFile = FMLPaths.CONFIGDIR.get().resolve(dir).resolve((String)fileName).toFile()).exists()) {
            return false;
        }
        try (FileReader reader = new FileReader(configFile);){
            JsonObject root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (root == null) return false;
            if (!root.has(key)) return false;
            JsonElement element = root.get(key);
            if (!element.isJsonPrimitive()) return false;
            if (!element.getAsJsonPrimitive().isBoolean()) return false;
            boolean bl = element.getAsBoolean();
            return bl;
        }
        catch (JsonParseException | IOException e) {
            LOGGER.log(Level.SEVERE, "Error reading or parsing config file: {0}", e.getMessage());
        }
        return false;
    }

    public static boolean setBooleanValue(String dir, String fileName, String key, boolean value) {
        boolean bl;
        File configFile;
        if (!((String)fileName).endsWith(".json")) {
            fileName = (String)fileName + ".json";
        }
        if (!(configFile = FMLPaths.CONFIGDIR.get().resolve(dir).resolve((String)fileName).toFile()).exists() && !JaumlConfigLib.createConfigFile(dir, (String)fileName)) {
            LOGGER.log(Level.SEVERE, "Failed to create config file: {0}", configFile.getPath());
            return false;
        }
        JsonObject root = new JsonObject();
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                if (root == null) {
                    root = new JsonObject();
                }
            }
            catch (JsonParseException | IOException e) {
                LOGGER.log(Level.SEVERE, "Error reading or parsing config file: {0}", e.getMessage());
                return false;
            }
        }
        root.addProperty(key, Boolean.valueOf(value));
        FileWriter writer = new FileWriter(configFile);
        try {
            GSON.toJson((JsonElement)root, (Appendable)writer);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Error writing to config file: {0}", e.getMessage());
                return false;
            }
        }
        writer.close();
        return bl;
    }
}

