/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.common.entities.projectiles;

import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import tech.alexnijjar.endermanoverhaul.common.entities.projectiles.base.BaseThrownPearl;
import tech.alexnijjar.endermanoverhaul.common.registry.ModEntityTypes;
import tech.alexnijjar.endermanoverhaul.common.registry.ModItems;
import tech.alexnijjar.endermanoverhaul.common.utils.ModUtils;

public class ThrownCrimsonPearl
extends BaseThrownPearl {
    public ThrownCrimsonPearl(EntityType<? extends ThrownCrimsonPearl> type, Level level) {
        super(type, level);
    }

    public ThrownCrimsonPearl(Level level, LivingEntity shooter) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntityTypes.CRIMSON_PEARL.get()), shooter, level);
    }

    @NotNull
    protected Item getDefaultItem() {
        return (Item)ModItems.CRIMSON_PEARL.get();
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        super.onHitEntity(result);
        result.getEntity().hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 0.0f);
    }

    protected void onHit(@NotNull HitResult result) {
        super.onHit(result);
        if (this.level().isClientSide() || this.isRemoved()) {
            return;
        }
        for (int i = 0; i < 32; ++i) {
            ModUtils.sendParticles((ServerLevel)this.level(), ParticleTypes.PORTAL, this.getX(), this.getY() - 1.0 + this.random.nextDouble() * 2.0, this.getZ(), 1, 0.0, 0.0, 0.0, -1.3);
        }
        Entity entity = this.getOwner();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        if (entity2 instanceof ServerPlayer) {
            Endermite endermite;
            ServerPlayer serverPlayer = (ServerPlayer)entity2;
            if (this.random.nextFloat() < 0.05f && this.level().getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && (endermite = (Endermite)EntityType.ENDERMITE.create(this.level())) != null) {
                endermite.moveTo(entity2.getX(), entity2.getY(), entity2.getZ(), entity2.getYRot(), entity2.getXRot());
                this.level().addFreshEntity((Entity)endermite);
            }
            if (serverPlayer.connection.isAcceptingMessages() && serverPlayer.level() == this.level() && !serverPlayer.isSleeping()) {
                if (entity2.isPassenger()) {
                    serverPlayer.dismountTo(this.getX(), this.getY(), this.getZ());
                } else {
                    entity2.teleportTo(this.getX(), this.getY(), this.getZ());
                }
                entity2.resetFallDistance();
                entity2.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 300, 1));
            }
        } else {
            entity2.teleportTo(this.getX(), this.getY(), this.getZ());
            entity2.resetFallDistance();
        }
        this.discard();
    }
}

