/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.common.entities.projectiles;

import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.alexnijjar.endermanoverhaul.common.entities.projectiles.base.BaseThrownPearl;
import tech.alexnijjar.endermanoverhaul.common.registry.ModEntityTypes;
import tech.alexnijjar.endermanoverhaul.common.registry.ModItems;
import tech.alexnijjar.endermanoverhaul.common.registry.ModParticleTypes;
import tech.alexnijjar.endermanoverhaul.common.registry.ModSoundEvents;
import tech.alexnijjar.endermanoverhaul.common.utils.ModUtils;

public class ThrownSoulPearl
extends BaseThrownPearl {
    @Nullable
    private Entity boundEntity;

    public ThrownSoulPearl(EntityType<? extends ThrownSoulPearl> type, Level level) {
        super(type, level);
    }

    public ThrownSoulPearl(Level level, LivingEntity shooter, @NotNull Entity boundEntity) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntityTypes.CORRUPTED_PEARL.get()), shooter, level);
        this.boundEntity = boundEntity;
    }

    @NotNull
    protected Item getDefaultItem() {
        return (Item)ModItems.CORRUPTED_PEARL.get();
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        super.onHitEntity(result);
        result.getEntity().hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 0.0f);
    }

    protected void onHit(@NotNull HitResult result) {
        super.onHit(result);
        if (this.level().isClientSide() || this.isRemoved()) {
            return;
        }
        for (int i = 0; i < 32; ++i) {
            ModUtils.sendParticles((ServerLevel)this.level(), (SimpleParticleType)ModParticleTypes.SOUL_FIRE_FLAME.get(), this.getX(), this.getY() - 1.0 + this.random.nextDouble() * 2.0, this.getZ(), 1, 0.0, 0.0, 0.0, -1.3);
        }
        if (this.boundEntity != null) {
            Endermite endermite;
            if (this.boundEntity.getType().is(Tags.EntityTypes.TELEPORTING_NOT_SUPPORTED)) {
                return;
            }
            if (this.random.nextFloat() < 0.05f && this.level().getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && (endermite = (Endermite)EntityType.ENDERMITE.create(this.level())) != null) {
                endermite.moveTo(this.boundEntity.getX(), this.boundEntity.getY(), this.boundEntity.getZ(), this.boundEntity.getYRot(), this.boundEntity.getXRot());
                this.level().addFreshEntity((Entity)endermite);
            }
            this.boundEntity.playSound(SoundEvents.CHORUS_FRUIT_TELEPORT, 1.0f, 1.0f);
            this.boundEntity.hurt(this.damageSources().fall(), 5.0f);
            if (this.isOnFire()) {
                this.boundEntity.igniteForSeconds(5.0f);
                this.boundEntity.hurt(this.damageSources().onFire(), 10.0f);
            }
            this.boundEntity.resetFallDistance();
            this.boundEntity.teleportTo(this.getX(), this.getY(), this.getZ());
        }
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (SoundEvent)ModSoundEvents.SOUL_PEARL_HIT.get(), this.getSoundSource(), 1.0f, this.random.nextFloat() * 0.4f + 0.8f);
        this.discard();
    }
}

