/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.structure.processor;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public interface ISafeWorldModifier {
    default public FluidState getFluidStateSafe(LevelChunkSection chunkSection, BlockPos pos) {
        if (chunkSection == null) {
            return Fluids.EMPTY.defaultFluidState();
        }
        return chunkSection.getFluidState(SectionPos.sectionRelative((int)pos.getX()), SectionPos.sectionRelative((int)pos.getY()), SectionPos.sectionRelative((int)pos.getZ()));
    }

    default public FluidState getFluidStateSafe(LevelReader world, BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        ChunkAccess chunk = world.getChunk(chunkPos.x, chunkPos.z);
        int sectionYIndex = world.getSectionIndex(pos.getY());
        LevelChunkSection chunkSection = chunk.getSection(sectionYIndex);
        return this.getFluidStateSafe(chunkSection, pos);
    }

    default public Optional<BlockState> getBlockStateSafe(LevelChunkSection chunkSection, BlockPos pos) {
        if (chunkSection == null) {
            return Optional.empty();
        }
        return Optional.of(chunkSection.getBlockState(SectionPos.sectionRelative((int)pos.getX()), SectionPos.sectionRelative((int)pos.getY()), SectionPos.sectionRelative((int)pos.getZ())));
    }

    default public Optional<BlockState> getBlockStateSafe(LevelReader world, BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        ChunkAccess chunk = world.getChunk(chunkPos.x, chunkPos.z);
        int sectionYIndex = world.getSectionIndex(pos.getY());
        LevelChunkSection chunkSection = chunk.getSection(sectionYIndex);
        return this.getBlockStateSafe(chunkSection, pos);
    }

    default public boolean isBlockStateAirSafe(LevelReader world, BlockPos pos) {
        Optional<BlockState> blockState = this.getBlockStateSafe(world, pos);
        return blockState.isPresent() && blockState.get().isAir();
    }

    default public boolean isMaterialLiquidSafe(LevelReader world, BlockPos pos) {
        Optional<BlockState> blockState = this.getBlockStateSafe(world, pos);
        return blockState.isPresent() && blockState.get().liquid();
    }

    default public Optional<BlockState> setBlockStateSafe(LevelChunkSection chunkSection, BlockPos pos, BlockState state) {
        if (chunkSection == null) {
            return Optional.empty();
        }
        return Optional.of(chunkSection.setBlockState(SectionPos.sectionRelative((int)pos.getX()), SectionPos.sectionRelative((int)pos.getY()), SectionPos.sectionRelative((int)pos.getZ()), state, false));
    }

    default public Optional<BlockState> setBlockStateSafe(LevelReader world, BlockPos pos, BlockState state) {
        ChunkPos chunkPos = new ChunkPos(pos);
        ChunkAccess chunk = world.getChunk(chunkPos.x, chunkPos.z);
        int sectionYIndex = chunk.getSectionIndex(pos.getY());
        LevelChunkSection chunkSection = chunk.getSection(sectionYIndex);
        return this.setBlockStateSafe(chunkSection, pos, state);
    }
}

