/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.config.option;

import com.terraformersmc.modmenu.config.option.ConfigOptionStorage;
import com.terraformersmc.modmenu.config.option.OptionConvertable;
import com.terraformersmc.modmenu.util.TranslationUtil;
import net.minecraft.client.OptionInstance;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class BooleanConfigOption
implements OptionConvertable {
    private final String key;
    private final String translationKey;
    private final boolean defaultValue;
    private final Component enabledText;
    private final Component disabledText;

    public BooleanConfigOption(String key, boolean defaultValue, String enabledKey, String disabledKey) {
        ConfigOptionStorage.setBoolean(key, defaultValue);
        this.key = key;
        this.translationKey = TranslationUtil.translationKeyOf("option", key);
        this.defaultValue = defaultValue;
        this.enabledText = Component.translatable((String)(this.translationKey + "." + enabledKey));
        this.disabledText = Component.translatable((String)(this.translationKey + "." + disabledKey));
    }

    public BooleanConfigOption(String key, boolean defaultValue) {
        this(key, defaultValue, "true", "false");
    }

    public String getKey() {
        return this.key;
    }

    public boolean getValue() {
        return ConfigOptionStorage.getBoolean(this.key);
    }

    public void setValue(boolean value) {
        ConfigOptionStorage.setBoolean(this.key, value);
    }

    public void toggleValue() {
        ConfigOptionStorage.toggleBoolean(this.key);
    }

    public boolean getDefaultValue() {
        return this.defaultValue;
    }

    public Component getButtonText() {
        return CommonComponents.optionNameValue((Component)Component.translatable((String)this.translationKey), (Component)(this.getValue() ? this.enabledText : this.disabledText));
    }

    public OptionInstance<Boolean> asOption() {
        if (this.enabledText != null && this.disabledText != null) {
            return new OptionInstance(this.translationKey, OptionInstance.noTooltip(), (text, value) -> value != false ? this.enabledText : this.disabledText, (OptionInstance.ValueSet)OptionInstance.BOOLEAN_VALUES, (Object)this.getValue(), newValue -> ConfigOptionStorage.setBoolean(this.key, newValue));
        }
        return OptionInstance.createBoolean((String)this.translationKey, (boolean)this.getValue(), value -> ConfigOptionStorage.setBoolean(this.key, value));
    }
}

