/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.config.option;

import com.mojang.serialization.Codec;
import com.terraformersmc.modmenu.config.option.ConfigOptionStorage;
import com.terraformersmc.modmenu.config.option.OptionConvertable;
import com.terraformersmc.modmenu.util.TranslationUtil;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.client.OptionInstance;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class EnumConfigOption<E extends Enum<E>>
implements OptionConvertable {
    private final String key;
    private final String translationKey;
    private final Class<E> enumClass;
    private final E defaultValue;

    public EnumConfigOption(String key, E defaultValue) {
        ConfigOptionStorage.setEnum(key, defaultValue);
        this.key = key;
        this.translationKey = TranslationUtil.translationKeyOf("option", key);
        this.enumClass = ((Enum)defaultValue).getDeclaringClass();
        this.defaultValue = defaultValue;
    }

    public String getKey() {
        return this.key;
    }

    public E getValue() {
        return ConfigOptionStorage.getEnum(this.key, this.enumClass);
    }

    public void setValue(E value) {
        ConfigOptionStorage.setEnum(this.key, value);
    }

    public void cycleValue() {
        ConfigOptionStorage.cycleEnum(this.key, this.enumClass);
    }

    public void cycleValue(int amount) {
        ConfigOptionStorage.cycleEnum(this.key, this.enumClass, amount);
    }

    public E getDefaultValue() {
        return this.defaultValue;
    }

    private static <E extends Enum<E>> Component getValueText(EnumConfigOption<E> option, E value) {
        return Component.translatable((String)(option.translationKey + "." + value.name().toLowerCase(Locale.ROOT)));
    }

    public Component getButtonText() {
        return CommonComponents.optionNameValue((Component)Component.translatable((String)this.translationKey), (Component)EnumConfigOption.getValueText(this, this.getValue()));
    }

    public OptionInstance<E> asOption() {
        return new OptionInstance(this.translationKey, OptionInstance.noTooltip(), (text, value) -> EnumConfigOption.getValueText(this, value), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList((Enum[])this.enumClass.getEnumConstants()), Codec.STRING.xmap(string -> Arrays.stream((Enum[])this.enumClass.getEnumConstants()).filter(e -> e.name().toLowerCase().equals(string)).findAny().orElse(null), newValue -> newValue.name().toLowerCase())), this.getValue(), value -> ConfigOptionStorage.setEnum(this.key, value));
    }
}

