/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.event;

import com.mojang.blaze3d.platform.InputConstants;
import com.terraformersmc.modmenu.api.ModMenuApi;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.gui.ModsScreen;
import com.terraformersmc.modmenu.gui.widget.ModMenuButtonWidget;
import com.terraformersmc.modmenu.gui.widget.UpdateCheckerTexturedButtonWidget;
import com.terraformersmc.modmenu.util.UpdateCheckerUtil;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;

public class ModMenuEventHandler {
    public static final ResourceLocation MODS_BUTTON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"modmenu", (String)"textures/gui/mods_button.png");
    private static KeyMapping MENU_KEY_BIND;

    public static void register() {
        MENU_KEY_BIND = KeyBindingHelper.registerKeyBinding((KeyMapping)new KeyMapping("key.modmenu.open_menu", InputConstants.Type.KEYSYM, InputConstants.UNKNOWN.getValue(), "key.categories.misc"));
        ClientTickEvents.END_CLIENT_TICK.register(ModMenuEventHandler::onClientEndTick);
        ScreenEvents.AFTER_INIT.register(ModMenuEventHandler::afterScreenInit);
    }

    public static void afterScreenInit(Minecraft client, Screen screen, int scaledWidth, int scaledHeight) {
        if (screen instanceof TitleScreen) {
            ModMenuEventHandler.afterTitleScreenInit(screen);
        }
    }

    private static void afterTitleScreenInit(Screen screen) {
        List buttons = Screens.getButtons((Screen)screen);
        if (ModMenuConfig.MODIFY_TITLE_SCREEN.getValue()) {
            int modsButtonIndex = -1;
            int spacing = 24;
            int buttonsY = screen.height / 4 + 48;
            for (int i = 0; i < buttons.size(); ++i) {
                AbstractWidget widget = (AbstractWidget)buttons.get(i);
                if (!(widget instanceof Button)) continue;
                Button button2 = (Button)widget;
                if (ModMenuConfig.MODS_BUTTON_STYLE.getValue() == ModMenuConfig.TitleMenuButtonStyle.CLASSIC && button2.visible) {
                    ModMenuEventHandler.shiftButtons((LayoutElement)button2, modsButtonIndex == -1, 24);
                    if (modsButtonIndex == -1) {
                        buttonsY = button2.getY();
                    }
                }
                if (!ModMenuEventHandler.buttonHasText((LayoutElement)button2, "menu.online")) continue;
                if (ModMenuConfig.MODS_BUTTON_STYLE.getValue() == ModMenuConfig.TitleMenuButtonStyle.REPLACE_REALMS) {
                    buttons.set(i, new ModMenuButtonWidget(button2.getX(), button2.getY(), button2.getWidth(), button2.getHeight(), ModMenuApi.createModsButtonText(), screen));
                    continue;
                }
                if (ModMenuConfig.MODS_BUTTON_STYLE.getValue() == ModMenuConfig.TitleMenuButtonStyle.SHRINK) {
                    button2.setWidth(98);
                }
                modsButtonIndex = i + 1;
                if (!button2.visible) continue;
                buttonsY = button2.getY();
            }
            if (modsButtonIndex != -1) {
                if (ModMenuConfig.MODS_BUTTON_STYLE.getValue() == ModMenuConfig.TitleMenuButtonStyle.CLASSIC) {
                    buttons.add(modsButtonIndex, new ModMenuButtonWidget(screen.width / 2 - 100, buttonsY + 24, 200, 20, ModMenuApi.createModsButtonText(), screen));
                } else if (ModMenuConfig.MODS_BUTTON_STYLE.getValue() == ModMenuConfig.TitleMenuButtonStyle.SHRINK) {
                    buttons.add(modsButtonIndex, new ModMenuButtonWidget(screen.width / 2 + 2, buttonsY, 98, 20, ModMenuApi.createModsButtonText(), screen));
                } else if (ModMenuConfig.MODS_BUTTON_STYLE.getValue() == ModMenuConfig.TitleMenuButtonStyle.ICON) {
                    buttons.add(modsButtonIndex, new UpdateCheckerTexturedButtonWidget(screen.width / 2 + 104, buttonsY, 20, 20, 0, 0, 20, MODS_BUTTON_TEXTURE, 32, 64, button -> Minecraft.getInstance().setScreen((Screen)new ModsScreen(screen)), ModMenuApi.createModsButtonText()));
                }
            }
        }
        UpdateCheckerUtil.triggerV2DeprecatedToast();
    }

    private static void onClientEndTick(Minecraft client) {
        while (MENU_KEY_BIND.consumeClick()) {
            client.setScreen((Screen)new ModsScreen(client.screen));
        }
    }

    public static boolean buttonHasText(LayoutElement widget, String ... translationKeys) {
        if (widget instanceof Button) {
            Button button = (Button)widget;
            Component text = button.getMessage();
            ComponentContents textContent = text.getContents();
            return textContent instanceof TranslatableContents && Arrays.stream(translationKeys).anyMatch(s -> ((TranslatableContents)textContent).getKey().equals(s));
        }
        return false;
    }

    public static void shiftButtons(LayoutElement widget, boolean shiftUp, int spacing) {
        AbstractWidget button;
        if (shiftUp) {
            widget.setY(widget.getY() - spacing / 2);
        } else if (!(widget instanceof AbstractWidget) || !(button = (AbstractWidget)widget).getMessage().equals((Object)Component.translatable((String)"title.credits"))) {
            widget.setY(widget.getY() + spacing / 2);
        }
    }
}

