/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.gui;

import com.google.common.base.Joiner;
import com.mojang.blaze3d.systems.RenderSystem;
import com.terraformersmc.modmenu.ModMenu;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.config.ModMenuConfigManager;
import com.terraformersmc.modmenu.gui.widget.DescriptionListWidget;
import com.terraformersmc.modmenu.gui.widget.LegacyTexturedButtonWidget;
import com.terraformersmc.modmenu.gui.widget.ModListWidget;
import com.terraformersmc.modmenu.gui.widget.entries.ModListEntry;
import com.terraformersmc.modmenu.util.DrawingUtil;
import com.terraformersmc.modmenu.util.ModMenuScreenTexts;
import com.terraformersmc.modmenu.util.TranslationUtil;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.ModBadgeRenderer;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.CommonLinks;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModsScreen
extends Screen {
    private static final ResourceLocation FILTERS_BUTTON_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"modmenu", (String)"textures/gui/filters_button.png");
    private static final ResourceLocation CONFIGURE_BUTTON_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"modmenu", (String)"textures/gui/configure_button.png");
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Mod Menu | ModsScreen");
    private final Screen previousScreen;
    private ModListEntry selected;
    private ModBadgeRenderer modBadgeRenderer;
    private double scrollPercent = 0.0;
    private boolean keepFilterOptionsShown = false;
    private boolean init = false;
    private boolean filterOptionsShown = false;
    private static final int RIGHT_PANE_Y = 48;
    private int paneWidth;
    private int rightPaneX;
    private int searchBoxX;
    private int filtersX;
    private int filtersWidth;
    private int searchRowWidth;
    public final Set<String> showModChildren = new HashSet<String>();
    private EditBox searchBox;
    @Nullable
    private AbstractWidget filtersButton;
    private AbstractWidget sortingButton;
    private AbstractWidget librariesButton;
    private ModListWidget modList;
    @Nullable
    private AbstractWidget configureButton;
    private AbstractWidget websiteButton;
    private AbstractWidget issuesButton;
    private DescriptionListWidget descriptionListWidget;
    private AbstractWidget modsFolderButton;
    private AbstractWidget doneButton;
    public final Map<String, Boolean> modHasConfigScreen = new HashMap<String, Boolean>();
    public final Map<String, Throwable> modScreenErrors = new HashMap<String, Throwable>();
    private static final Component SEND_FEEDBACK_TEXT = Component.translatable((String)"menu.sendFeedback");
    private static final Component REPORT_BUGS_TEXT = Component.translatable((String)"menu.reportBugs");

    public ModsScreen(Screen previousScreen) {
        super(ModMenuScreenTexts.TITLE);
        this.previousScreen = previousScreen;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.modList.isMouseOver(mouseX, mouseY)) {
            return this.modList.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
        }
        if (this.descriptionListWidget.isMouseOver(mouseX, mouseY)) {
            return this.descriptionListWidget.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
        }
        return false;
    }

    protected void init() {
        int paneY = ModMenuConfig.CONFIG_MODE.getValue() ? 48 : 67;
        this.paneWidth = this.width / 2 - 8;
        this.rightPaneX = this.width - this.paneWidth;
        this.modList = new ModListWidget(this.minecraft, this.paneWidth, this.height - paneY - 36, paneY, ModMenuConfig.COMPACT_LIST.getValue() ? 23 : 36, this.modList, this);
        this.modList.setX(0);
        int filtersButtonSize = ModMenuConfig.CONFIG_MODE.getValue() ? 0 : 22;
        int searchWidthMax = this.paneWidth - 32 - filtersButtonSize;
        int searchBoxWidth = ModMenuConfig.CONFIG_MODE.getValue() ? Math.min(200, searchWidthMax) : searchWidthMax;
        this.searchBoxX = this.paneWidth / 2 - searchBoxWidth / 2 - filtersButtonSize / 2;
        this.searchBox = new EditBox(this.font, this.searchBoxX, 22, searchBoxWidth, 20, this.searchBox, ModMenuScreenTexts.SEARCH);
        this.searchBox.setResponder(text -> this.modList.filter((String)text, false));
        Component sortingText = ModMenuConfig.SORTING.getButtonText();
        Component librariesText = ModMenuConfig.SHOW_LIBRARIES.getButtonText();
        int sortingWidth = this.font.width((FormattedText)sortingText) + 20;
        int librariesWidth = this.font.width((FormattedText)librariesText) + 20;
        this.filtersWidth = librariesWidth + sortingWidth + 2;
        this.searchRowWidth = this.searchBoxX + searchBoxWidth + 22;
        this.updateFiltersX();
        if (!ModMenuConfig.CONFIG_MODE.getValue()) {
            this.filtersButton = LegacyTexturedButtonWidget.legacyTexturedBuilder(ModMenuScreenTexts.TOGGLE_FILTER_OPTIONS, button -> this.setFilterOptionsShown(!this.filterOptionsShown)).position(this.paneWidth / 2 + searchBoxWidth / 2 - 10 + 2, 22).size(20, 20).uv(0, 0, 20).texture(FILTERS_BUTTON_LOCATION, 32, 64).build();
            this.filtersButton.setTooltip(Tooltip.create((Component)ModMenuScreenTexts.TOGGLE_FILTER_OPTIONS));
        }
        this.sortingButton = Button.builder((Component)sortingText, button -> {
            ModMenuConfig.SORTING.cycleValue();
            ModMenuConfigManager.save();
            this.modList.reloadFilters();
            button.setMessage(ModMenuConfig.SORTING.getButtonText());
        }).pos(this.filtersX, 45).size(sortingWidth, 20).build();
        this.librariesButton = Button.builder((Component)librariesText, button -> {
            ModMenuConfig.SHOW_LIBRARIES.toggleValue();
            ModMenuConfigManager.save();
            this.modList.reloadFilters();
            button.setMessage(ModMenuConfig.SHOW_LIBRARIES.getButtonText());
        }).pos(this.filtersX + sortingWidth + 2, 45).size(librariesWidth, 20).build();
        if (!ModMenuConfig.HIDE_CONFIG_BUTTONS.getValue()) {
            this.configureButton = LegacyTexturedButtonWidget.legacyTexturedBuilder(CommonComponents.EMPTY, button -> {
                String id = Objects.requireNonNull(this.selected).getMod().getId();
                if (this.getModHasConfigScreen(id)) {
                    this.safelyOpenConfigScreen(id);
                } else {
                    button.active = false;
                }
            }).position(this.width - 24, 48).size(20, 20).uv(0, 0, 20).texture(CONFIGURE_BUTTON_LOCATION, 32, 64).build();
        }
        int urlButtonWidths = this.paneWidth / 2 - 2;
        int cappedButtonWidth = Math.min(urlButtonWidths, 200);
        this.websiteButton = Button.builder((Component)ModMenuScreenTexts.WEBSITE, button -> {
            Mod mod = Objects.requireNonNull(this.selected).getMod();
            boolean isMinecraft = this.selected.getMod().getId().equals("minecraft");
            if (isMinecraft) {
                URI url = SharedConstants.getCurrentVersion().isStable() ? CommonLinks.RELEASE_FEEDBACK : CommonLinks.SNAPSHOT_FEEDBACK;
                ConfirmLinkScreen.confirmLinkNow((Screen)this, (URI)url, (boolean)true);
            } else {
                String url = mod.getWebsite();
                ConfirmLinkScreen.confirmLinkNow((Screen)this, (String)url, (boolean)false);
            }
        }).pos(this.rightPaneX + urlButtonWidths / 2 - cappedButtonWidth / 2, 84).size(Math.min(urlButtonWidths, 200), 20).build();
        this.issuesButton = Button.builder((Component)ModMenuScreenTexts.ISSUES, button -> {
            Mod mod = Objects.requireNonNull(this.selected).getMod();
            boolean isMinecraft = this.selected.getMod().getId().equals("minecraft");
            if (isMinecraft) {
                ConfirmLinkScreen.confirmLinkNow((Screen)this, (URI)CommonLinks.SNAPSHOT_BUGS_FEEDBACK, (boolean)true);
            } else {
                String url = mod.getIssueTracker();
                ConfirmLinkScreen.confirmLinkNow((Screen)this, (String)url, (boolean)false);
            }
        }).pos(this.rightPaneX + urlButtonWidths + 4 + urlButtonWidths / 2 - cappedButtonWidth / 2, 84).size(Math.min(urlButtonWidths, 200), 20).build();
        Objects.requireNonNull(this.font);
        this.descriptionListWidget = new DescriptionListWidget(this.minecraft, this.paneWidth, this.height - 48 - 96, 108, 9 + 1, this);
        this.descriptionListWidget.setX(this.rightPaneX);
        this.modsFolderButton = Button.builder((Component)ModMenuScreenTexts.MODS_FOLDER, button -> Util.getPlatform().openUri(FabricLoader.getInstance().getGameDir().resolve("mods").toUri())).pos(this.width / 2 - 154, this.height - 28).size(150, 20).build();
        this.doneButton = Button.builder((Component)CommonComponents.GUI_DONE, button -> this.minecraft.setScreen(this.previousScreen)).pos(this.width / 2 + 4, this.height - 28).size(150, 20).build();
        this.modList.reloadFilters();
        this.setFilterOptionsShown(this.keepFilterOptionsShown && this.filterOptionsShown);
        this.addWidget((GuiEventListener)this.searchBox);
        this.setInitialFocus((GuiEventListener)this.searchBox);
        if (this.filtersButton != null) {
            this.addRenderableWidget((GuiEventListener)this.filtersButton);
        }
        this.addRenderableWidget((GuiEventListener)this.sortingButton);
        this.addRenderableWidget((GuiEventListener)this.librariesButton);
        this.addWidget((GuiEventListener)this.modList);
        if (this.configureButton != null) {
            this.addRenderableWidget((GuiEventListener)this.configureButton);
        }
        this.addRenderableWidget((GuiEventListener)this.websiteButton);
        this.addRenderableWidget((GuiEventListener)this.issuesButton);
        this.addWidget((GuiEventListener)this.descriptionListWidget);
        this.addRenderableWidget((GuiEventListener)this.modsFolderButton);
        this.addRenderableWidget((GuiEventListener)this.doneButton);
        this.init = true;
        this.keepFilterOptionsShown = true;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return super.keyPressed(keyCode, scanCode, modifiers) || this.searchBox.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char chr, int keyCode) {
        return this.searchBox.charTyped(chr, keyCode);
    }

    public void render(GuiGraphics DrawContext, int mouseX, int mouseY, float delta) {
        super.render(DrawContext, mouseX, mouseY, delta);
        ModListEntry selectedEntry = this.selected;
        if (selectedEntry != null) {
            this.descriptionListWidget.render(DrawContext, mouseX, mouseY, delta);
        }
        this.modList.render(DrawContext, mouseX, mouseY, delta);
        this.searchBox.render(DrawContext, mouseX, mouseY, delta);
        RenderSystem.disableBlend();
        DrawContext.drawCenteredString(this.font, this.title, this.modList.getWidth() / 2, 8, 0xFFFFFF);
        if (!ModMenuConfig.DISABLE_DRAG_AND_DROP.getValue()) {
            int n = this.width - this.modList.getWidth() / 2;
            Objects.requireNonNull(this.minecraft.font);
            DrawContext.drawCenteredString(this.font, ModMenuScreenTexts.DROP_INFO_LINE_1, n, 24 - 9 - 1, ChatFormatting.GRAY.getColor().intValue());
            DrawContext.drawCenteredString(this.font, ModMenuScreenTexts.DROP_INFO_LINE_2, this.width - this.modList.getWidth() / 2, 25, ChatFormatting.GRAY.getColor().intValue());
        }
        if (!ModMenuConfig.CONFIG_MODE.getValue()) {
            Component fullModCount = this.computeModCountText(true);
            if (!ModMenuConfig.CONFIG_MODE.getValue() && this.updateFiltersX()) {
                if (this.filterOptionsShown) {
                    if (!ModMenuConfig.SHOW_LIBRARIES.getValue() || this.font.width((FormattedText)fullModCount) <= this.filtersX - 5) {
                        DrawContext.drawString(this.font, fullModCount.getVisualOrderText(), this.searchBoxX, 52, 0xFFFFFF, true);
                    } else {
                        DrawContext.drawString(this.font, this.computeModCountText(false).getVisualOrderText(), this.searchBoxX, 46, 0xFFFFFF, true);
                        DrawContext.drawString(this.font, this.computeLibraryCountText().getVisualOrderText(), this.searchBoxX, 57, 0xFFFFFF, true);
                    }
                } else if (!ModMenuConfig.SHOW_LIBRARIES.getValue() || this.font.width((FormattedText)fullModCount) <= this.modList.getWidth() - 5) {
                    DrawContext.drawString(this.font, fullModCount.getVisualOrderText(), this.searchBoxX, 52, 0xFFFFFF, true);
                } else {
                    DrawContext.drawString(this.font, this.computeModCountText(false).getVisualOrderText(), this.searchBoxX, 46, 0xFFFFFF, true);
                    DrawContext.drawString(this.font, this.computeLibraryCountText().getVisualOrderText(), this.searchBoxX, 57, 0xFFFFFF, true);
                }
            }
        }
        if (selectedEntry != null) {
            List<String> names;
            MutableComponent name;
            Mod mod = selectedEntry.getMod();
            int x = this.rightPaneX;
            if ("java".equals(mod.getId())) {
                DrawingUtil.drawRandomVersionBackground(mod, DrawContext, x, 48, 32, 32);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            DrawContext.blit(this.selected.getIconTexture(), x, 48, 0.0f, 0.0f, 32, 32, 32, 32);
            RenderSystem.disableBlend();
            Objects.requireNonNull(this.font);
            int lineSpacing = 9 + 1;
            int imageOffset = 36;
            MutableComponent trimmedName = name = Component.literal((String)mod.getTranslatedName());
            int maxNameWidth = this.width - (x + imageOffset);
            if (this.font.width((FormattedText)name) > maxNameWidth) {
                FormattedText ellipsis = FormattedText.of((String)"...");
                trimmedName = FormattedText.composite((FormattedText[])new FormattedText[]{this.font.substrByWidth((FormattedText)name, maxNameWidth - this.font.width(ellipsis)), ellipsis});
            }
            DrawContext.drawString(this.font, Language.getInstance().getVisualOrder((FormattedText)trimmedName), x + imageOffset, 49, 0xFFFFFF, true);
            if (mouseX > x + imageOffset && mouseY > 49) {
                Objects.requireNonNull(this.font);
                if (mouseY < 49 + 9 && mouseX < x + imageOffset + this.font.width((FormattedText)trimmedName)) {
                    this.setTooltipForNextRenderPass(ModMenuScreenTexts.modIdTooltip(mod.getId()));
                }
            }
            if (this.init || this.modBadgeRenderer == null || this.modBadgeRenderer.getMod() != mod) {
                this.modBadgeRenderer = new ModBadgeRenderer(x + imageOffset + this.minecraft.font.width((FormattedText)trimmedName) + 2, 48, this.width - 28, selectedEntry.mod, this);
                this.init = false;
            }
            if (!ModMenuConfig.HIDE_BADGES.getValue()) {
                this.modBadgeRenderer.draw(DrawContext, mouseX, mouseY);
            }
            if (mod.isReal()) {
                DrawContext.drawString(this.font, mod.getPrefixedVersion(), x + imageOffset, 50 + lineSpacing, 0x808080, true);
            }
            if (!(names = mod.getAuthors()).isEmpty()) {
                String authors = names.size() > 1 ? Joiner.on((String)", ").join(names) : names.get(0);
                DrawingUtil.drawWrappedString(DrawContext, I18n.get((String)"modmenu.authorPrefix", (Object[])new Object[]{authors}), x + imageOffset, 50 + lineSpacing * 2, this.paneWidth - imageOffset - 4, 1, 0x808080);
            }
        }
    }

    private Component computeModCountText(boolean includeLibs) {
        int[] rootMods = this.formatModCount(ModMenu.ROOT_MODS.values().stream().filter(mod -> !mod.isHidden() && !mod.getBadges().contains((Object)Mod.Badge.LIBRARY)).map(Mod::getId).collect(Collectors.toSet()));
        if (includeLibs && ModMenuConfig.SHOW_LIBRARIES.getValue()) {
            int[] rootLibs = this.formatModCount(ModMenu.ROOT_MODS.values().stream().filter(mod -> !mod.isHidden() && mod.getBadges().contains((Object)Mod.Badge.LIBRARY)).map(Mod::getId).collect(Collectors.toSet()));
            return TranslationUtil.translateNumeric("modmenu.showingModsLibraries", rootMods, rootLibs);
        }
        return TranslationUtil.translateNumeric("modmenu.showingMods", new int[][]{rootMods});
    }

    private Component computeLibraryCountText() {
        if (ModMenuConfig.SHOW_LIBRARIES.getValue()) {
            int[] rootLibs = this.formatModCount(ModMenu.ROOT_MODS.values().stream().filter(mod -> !mod.isHidden() && mod.getBadges().contains((Object)Mod.Badge.LIBRARY)).map(Mod::getId).collect(Collectors.toSet()));
            return TranslationUtil.translateNumeric("modmenu.showingLibraries", new int[][]{rootLibs});
        }
        return Component.literal(null);
    }

    private int[] formatModCount(Set<String> set) {
        int total;
        int visible = this.modList.getDisplayedCountFor(set);
        if (visible == (total = set.size())) {
            return new int[]{total};
        }
        return new int[]{visible, total};
    }

    public void onClose() {
        this.modList.close();
        this.minecraft.setScreen(this.previousScreen);
    }

    private void setFilterOptionsShown(boolean filterOptionsShown) {
        this.filterOptionsShown = filterOptionsShown;
        this.sortingButton.visible = filterOptionsShown;
        this.librariesButton.visible = filterOptionsShown;
    }

    public ModListEntry getSelectedEntry() {
        return this.selected;
    }

    public void updateSelectedEntry(ModListEntry entry) {
        if (entry != null) {
            boolean isMinecraft;
            this.selected = entry;
            String modId = this.selected.getMod().getId();
            if (this.configureButton != null) {
                this.configureButton.active = this.getModHasConfigScreen(modId);
                boolean bl = this.configureButton.visible = this.selected != null && this.getModHasConfigScreen(modId) || this.modScreenErrors.containsKey(modId);
                if (this.modScreenErrors.containsKey(modId)) {
                    Throwable e = this.modScreenErrors.get(modId);
                    this.configureButton.setTooltip(Tooltip.create((Component)ModMenuScreenTexts.configureError(modId, e)));
                } else {
                    this.configureButton.setTooltip(Tooltip.create((Component)ModMenuScreenTexts.CONFIGURE));
                }
            }
            if (isMinecraft = modId.equals("minecraft")) {
                this.websiteButton.setMessage(SEND_FEEDBACK_TEXT);
                this.issuesButton.setMessage(REPORT_BUGS_TEXT);
            } else {
                this.websiteButton.setMessage(ModMenuScreenTexts.WEBSITE);
                this.issuesButton.setMessage(ModMenuScreenTexts.ISSUES);
            }
            this.websiteButton.visible = true;
            this.websiteButton.active = isMinecraft || this.selected.getMod().getWebsite() != null;
            this.issuesButton.visible = true;
            this.issuesButton.active = isMinecraft || this.selected.getMod().getIssueTracker() != null;
        }
    }

    public double getScrollPercent() {
        return this.scrollPercent;
    }

    public void updateScrollPercent(double scrollPercent) {
        this.scrollPercent = scrollPercent;
    }

    public String getSearchInput() {
        return this.searchBox.getValue();
    }

    private boolean updateFiltersX() {
        if (this.filtersWidth + this.font.width((FormattedText)this.computeModCountText(true)) + 20 >= this.searchRowWidth && (this.filtersWidth + this.font.width((FormattedText)this.computeModCountText(false)) + 20 >= this.searchRowWidth || this.filtersWidth + this.font.width((FormattedText)this.computeLibraryCountText()) + 20 >= this.searchRowWidth)) {
            this.filtersX = this.paneWidth / 2 - this.filtersWidth / 2;
            return !this.filterOptionsShown;
        }
        this.filtersX = this.searchRowWidth - this.filtersWidth + 1;
        return true;
    }

    public void onFilesDrop(List<Path> paths) {
        Path modsDirectory = FabricLoader.getInstance().getGameDir().resolve("mods");
        List mods = paths.stream().filter(ModsScreen::isValidMod).collect(Collectors.toList());
        if (mods.isEmpty()) {
            return;
        }
        String modList = mods.stream().map(Path::getFileName).map(Path::toString).collect(Collectors.joining(", "));
        this.minecraft.setScreen((Screen)new ConfirmScreen(value -> {
            if (value) {
                boolean allSuccessful = true;
                for (Path path : mods) {
                    try {
                        Files.copy(path, modsDirectory.resolve(path.getFileName()), new CopyOption[0]);
                    }
                    catch (IOException e) {
                        LOGGER.warn("Failed to copy mod from {} to {}", (Object)path, (Object)modsDirectory.resolve(path.getFileName()));
                        SystemToast.onPackCopyFailure((Minecraft)this.minecraft, (String)path.toString());
                        allSuccessful = false;
                        break;
                    }
                }
                if (allSuccessful) {
                    SystemToast.add((ToastComponent)this.minecraft.getToasts(), (SystemToast.SystemToastId)SystemToast.SystemToastId.PERIODIC_NOTIFICATION, (Component)ModMenuScreenTexts.DROP_SUCCESSFUL_LINE_1, (Component)ModMenuScreenTexts.DROP_SUCCESSFUL_LINE_2);
                }
            }
            this.minecraft.setScreen((Screen)this);
        }, ModMenuScreenTexts.DROP_CONFIRM, (Component)Component.literal((String)modList)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isValidMod(Path mod) {
        try (JarFile jarFile = new JarFile(mod.toFile());){
            boolean isFabricMod;
            boolean bl = isFabricMod = jarFile.getEntry("fabric.mod.json") != null;
            if (!ModMenu.RUNNING_QUILT) {
                boolean bl2 = isFabricMod;
                return bl2;
            }
            boolean bl2 = isFabricMod || jarFile.getEntry("quilt.mod.json") != null;
            return bl2;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean getModHasConfigScreen(String modId) {
        if (this.modScreenErrors.containsKey(modId)) {
            return false;
        }
        return this.modHasConfigScreen.computeIfAbsent(modId, ModMenu::hasConfigScreen);
    }

    public void safelyOpenConfigScreen(String modId) {
        try {
            Screen screen = ModMenu.getConfigScreen(modId, this);
            if (screen != null) {
                this.minecraft.setScreen(screen);
            }
        }
        catch (NoClassDefFoundError e) {
            LOGGER.warn("The '" + modId + "' mod config screen is not available because " + e.getLocalizedMessage() + " is missing.");
            this.modScreenErrors.put(modId, e);
        }
        catch (Throwable e) {
            LOGGER.error("Error from mod '" + modId + "'", e);
            this.modScreenErrors.put(modId, e);
        }
    }
}

