/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.gui.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.terraformersmc.modmenu.api.UpdateInfo;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.gui.ModsScreen;
import com.terraformersmc.modmenu.gui.widget.UpdateAvailableBadge;
import com.terraformersmc.modmenu.gui.widget.entries.ModListEntry;
import com.terraformersmc.modmenu.util.mod.Mod;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.CreditsAndAttributionScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class DescriptionListWidget
extends AbstractSelectionList<DescriptionEntry> {
    private static final Component HAS_UPDATE_TEXT = Component.translatable((String)"modmenu.hasUpdate");
    private static final Component EXPERIMENTAL_TEXT = Component.translatable((String)"modmenu.experimental").withStyle(ChatFormatting.GOLD);
    private static final Component DOWNLOAD_TEXT = Component.translatable((String)"modmenu.downloadLink").withStyle(ChatFormatting.BLUE).withStyle(ChatFormatting.UNDERLINE);
    private static final Component CHILD_HAS_UPDATE_TEXT = Component.translatable((String)"modmenu.childHasUpdate");
    private static final Component LINKS_TEXT = Component.translatable((String)"modmenu.links");
    private static final Component SOURCE_TEXT = Component.translatable((String)"modmenu.source").withStyle(ChatFormatting.BLUE).withStyle(ChatFormatting.UNDERLINE);
    private static final Component LICENSE_TEXT = Component.translatable((String)"modmenu.license");
    private static final Component VIEW_CREDITS_TEXT = Component.translatable((String)"modmenu.viewCredits").withStyle(ChatFormatting.BLUE).withStyle(ChatFormatting.UNDERLINE);
    private static final Component CREDITS_TEXT = Component.translatable((String)"modmenu.credits");
    private final ModsScreen parent;
    private final Font textRenderer;
    private ModListEntry lastSelected = null;

    public DescriptionListWidget(Minecraft client, int width, int height, int y, int itemHeight, ModsScreen parent) {
        super(client, width, height, y, itemHeight);
        this.parent = parent;
        this.textRenderer = client.font;
    }

    public DescriptionEntry getSelectedOrNull() {
        return null;
    }

    public int getRowWidth() {
        return this.width - 10;
    }

    protected int getScrollbarPosition() {
        return this.width - 6 + this.getX();
    }

    public void updateWidgetNarration(NarrationElementOutput builder) {
        Mod mod = this.parent.getSelectedEntry().getMod();
        builder.add(NarratedElementType.TITLE, mod.getTranslatedName() + " " + mod.getPrefixedVersion());
    }

    public void renderListItems(GuiGraphics DrawContext, int mouseX, int mouseY, float delta) {
        ModListEntry selectedEntry = this.parent.getSelectedEntry();
        if (selectedEntry != this.lastSelected) {
            this.lastSelected = selectedEntry;
            this.clearEntries();
            this.setScrollAmount(-1.7976931348623157E308);
            if (this.lastSelected != null) {
                DescriptionEntry emptyEntry = new DescriptionEntry(FormattedCharSequence.EMPTY);
                int wrapWidth = this.getRowWidth() - 5;
                Mod mod = this.lastSelected.getMod();
                Component description = mod.getFormattedDescription();
                if (!description.getString().isEmpty()) {
                    for (FormattedCharSequence line : this.textRenderer.split((FormattedText)description, wrapWidth)) {
                        this.children().add(new DescriptionEntry(line));
                    }
                }
                if (ModMenuConfig.UPDATE_CHECKER.getValue() && !ModMenuConfig.DISABLE_UPDATE_CHECKER.getValue().contains(mod.getId())) {
                    Object entry;
                    UpdateInfo updateInfo = mod.getUpdateInfo();
                    if (updateInfo != null && updateInfo.isUpdateAvailable()) {
                        this.children().add(emptyEntry);
                        int index = 0;
                        for (Object line : this.textRenderer.split((FormattedText)HAS_UPDATE_TEXT, wrapWidth - 11)) {
                            entry = new DescriptionEntry((FormattedCharSequence)line);
                            if (index == 0) {
                                ((DescriptionEntry)((Object)entry)).setUpdateTextEntry();
                            }
                            this.children().add(entry);
                            ++index;
                        }
                        for (Object line : this.textRenderer.split((FormattedText)EXPERIMENTAL_TEXT, wrapWidth - 16)) {
                            this.children().add(new DescriptionEntry((FormattedCharSequence)line, 8));
                        }
                        Component updateMessage = updateInfo.getUpdateMessage();
                        String downloadLink = updateInfo.getDownloadLink();
                        if (updateMessage == null) {
                            updateMessage = DOWNLOAD_TEXT;
                        } else if (downloadLink != null) {
                            updateMessage = updateMessage.copy().withStyle(ChatFormatting.BLUE).withStyle(ChatFormatting.UNDERLINE);
                        }
                        for (FormattedCharSequence line : this.textRenderer.split((FormattedText)updateMessage, wrapWidth - 16)) {
                            if (downloadLink != null) {
                                this.children().add(new LinkEntry(line, downloadLink, 8));
                                continue;
                            }
                            this.children().add(new DescriptionEntry(line, 8));
                        }
                    }
                    if (mod.getChildHasUpdate()) {
                        this.children().add(emptyEntry);
                        int index = 0;
                        for (Object line : this.textRenderer.split((FormattedText)CHILD_HAS_UPDATE_TEXT, wrapWidth - 11)) {
                            entry = new DescriptionEntry((FormattedCharSequence)line);
                            if (index == 0) {
                                ((DescriptionEntry)((Object)entry)).setUpdateTextEntry();
                            }
                            this.children().add(entry);
                            ++index;
                        }
                    }
                }
                Map<String, String> links = mod.getLinks();
                String sourceLink = mod.getSource();
                if (!(links.isEmpty() && sourceLink == null || ModMenuConfig.HIDE_MOD_LINKS.getValue())) {
                    this.children().add(emptyEntry);
                    for (Object line : this.textRenderer.split((FormattedText)LINKS_TEXT, wrapWidth)) {
                        this.children().add(new DescriptionEntry((FormattedCharSequence)line));
                    }
                    if (sourceLink != null) {
                        int indent = 8;
                        for (Object line : this.textRenderer.split((FormattedText)SOURCE_TEXT, wrapWidth - 16)) {
                            this.children().add(new LinkEntry((FormattedCharSequence)line, sourceLink, indent));
                            indent = 16;
                        }
                    }
                    links.forEach((key, value) -> {
                        int indent = 8;
                        for (FormattedCharSequence line : this.textRenderer.split((FormattedText)Component.translatable((String)key).withStyle(ChatFormatting.BLUE).withStyle(ChatFormatting.UNDERLINE), wrapWidth - 16)) {
                            this.children().add(new LinkEntry(line, (String)value, indent));
                            indent = 16;
                        }
                    });
                }
                Set<String> licenses = mod.getLicense();
                if (!ModMenuConfig.HIDE_MOD_LICENSE.getValue() && !licenses.isEmpty()) {
                    this.children().add(emptyEntry);
                    for (Object line : this.textRenderer.split((FormattedText)LICENSE_TEXT, wrapWidth)) {
                        this.children().add(new DescriptionEntry((FormattedCharSequence)line));
                    }
                    for (String license : licenses) {
                        int indent = 8;
                        for (FormattedCharSequence line : this.textRenderer.split((FormattedText)Component.literal((String)license), wrapWidth - 16)) {
                            this.children().add(new DescriptionEntry(line, indent));
                            indent = 16;
                        }
                    }
                }
                if (!ModMenuConfig.HIDE_MOD_CREDITS.getValue()) {
                    SortedMap<String, Set<String>> credits;
                    if ("minecraft".equals(mod.getId())) {
                        this.children().add(emptyEntry);
                        for (Object line : this.textRenderer.split((FormattedText)VIEW_CREDITS_TEXT, wrapWidth)) {
                            this.children().add(new MojangCreditsEntry((FormattedCharSequence)line));
                        }
                    } else if (!"java".equals(mod.getId()) && !(credits = mod.getCredits()).isEmpty()) {
                        this.children().add(emptyEntry);
                        for (FormattedCharSequence line : this.textRenderer.split((FormattedText)CREDITS_TEXT, wrapWidth)) {
                            this.children().add(new DescriptionEntry(line));
                        }
                        Iterator<Map.Entry<String, Set<String>>> iterator = credits.entrySet().iterator();
                        while (iterator.hasNext()) {
                            int indent = 8;
                            Map.Entry<String, Set<String>> role = iterator.next();
                            String roleName = role.getKey();
                            for (FormattedCharSequence line : this.textRenderer.split((FormattedText)this.creditsRoleText(roleName), wrapWidth - 16)) {
                                this.children().add(new DescriptionEntry(line, indent));
                                indent = 16;
                            }
                            for (String contributor : role.getValue()) {
                                indent = 16;
                                for (FormattedCharSequence line : this.textRenderer.split((FormattedText)Component.literal((String)contributor), wrapWidth - 24)) {
                                    this.children().add(new DescriptionEntry(line, indent));
                                    indent = 24;
                                }
                            }
                            if (!iterator.hasNext()) continue;
                            this.children().add(emptyEntry);
                        }
                    }
                }
            }
        }
        Tesselator tessellator = Tesselator.getInstance();
        this.enableScissor(DrawContext);
        super.renderListItems(DrawContext, mouseX, mouseY, delta);
        DrawContext.disableScissor();
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder bufferBuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        bufferBuilder.addVertex((float)this.getX(), (float)(this.getY() + 4), 0.0f).setColor(0, 0, 0, 0);
        bufferBuilder.addVertex((float)this.getRight(), (float)(this.getY() + 4), 0.0f).setColor(0, 0, 0, 0);
        bufferBuilder.addVertex((float)this.getRight(), (float)this.getY(), 0.0f).setColor(0, 0, 0, 255);
        bufferBuilder.addVertex((float)this.getX(), (float)this.getY(), 0.0f).setColor(0, 0, 0, 255);
        bufferBuilder.addVertex((float)this.getX(), (float)this.getBottom(), 0.0f).setColor(0, 0, 0, 255);
        bufferBuilder.addVertex((float)this.getRight(), (float)this.getBottom(), 0.0f).setColor(0, 0, 0, 255);
        bufferBuilder.addVertex((float)this.getRight(), (float)(this.getBottom() - 4), 0.0f).setColor(0, 0, 0, 0);
        bufferBuilder.addVertex((float)this.getX(), (float)(this.getBottom() - 4), 0.0f).setColor(0, 0, 0, 0);
        try {
            MeshData builtBuffer = bufferBuilder.buildOrThrow();
            BufferUploader.drawWithShader((MeshData)builtBuffer);
            builtBuffer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.renderScrollBar(bufferBuilder, tessellator);
        RenderSystem.disableBlend();
    }

    public void renderScrollBar(BufferBuilder bufferBuilder, Tesselator tessellator) {
        int scrollbarStartX = this.getScrollbarPosition();
        int scrollbarEndX = scrollbarStartX + 6;
        int maxScroll = this.getMaxScroll();
        if (maxScroll > 0) {
            int p = (int)((float)((this.getBottom() - this.getY()) * (this.getBottom() - this.getY())) / (float)this.getMaxPosition());
            p = Mth.clamp((int)p, (int)32, (int)(this.getBottom() - this.getY() - 8));
            int q = (int)this.getScrollAmount() * (this.getBottom() - this.getY() - p) / maxScroll + this.getY();
            if (q < this.getY()) {
                q = this.getY();
            }
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            bufferBuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            bufferBuilder.addVertex((float)scrollbarStartX, (float)this.getBottom(), 0.0f).setColor(0, 0, 0, 255);
            bufferBuilder.addVertex((float)scrollbarEndX, (float)this.getBottom(), 0.0f).setColor(0, 0, 0, 255);
            bufferBuilder.addVertex((float)scrollbarEndX, (float)this.getY(), 0.0f).setColor(0, 0, 0, 255);
            bufferBuilder.addVertex((float)scrollbarStartX, (float)this.getY(), 0.0f).setColor(0, 0, 0, 255);
            bufferBuilder.addVertex((float)scrollbarStartX, (float)(q + p), 0.0f).setColor(128, 128, 128, 255);
            bufferBuilder.addVertex((float)scrollbarEndX, (float)(q + p), 0.0f).setColor(128, 128, 128, 255);
            bufferBuilder.addVertex((float)scrollbarEndX, (float)q, 0.0f).setColor(128, 128, 128, 255);
            bufferBuilder.addVertex((float)scrollbarStartX, (float)q, 0.0f).setColor(128, 128, 128, 255);
            bufferBuilder.addVertex((float)scrollbarStartX, (float)(q + p - 1), 0.0f).setColor(192, 192, 192, 255);
            bufferBuilder.addVertex((float)(scrollbarEndX - 1), (float)(q + p - 1), 0.0f).setColor(192, 192, 192, 255);
            bufferBuilder.addVertex((float)(scrollbarEndX - 1), (float)q, 0.0f).setColor(192, 192, 192, 255);
            bufferBuilder.addVertex((float)scrollbarStartX, (float)q, 0.0f).setColor(192, 192, 192, 255);
            try {
                MeshData builtBuffer = bufferBuilder.buildOrThrow();
                BufferUploader.drawWithShader((MeshData)builtBuffer);
                builtBuffer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Component creditsRoleText(String roleName) {
        String translationKey = roleName.replaceAll("[ -]", "_").toLowerCase();
        Object fallback = roleName.endsWith("r") ? roleName + "s" : roleName;
        return Component.translatableWithFallback((String)("modmenu.credits.role." + translationKey), (String)fallback).append((Component)Component.literal((String)":"));
    }

    protected class DescriptionEntry
    extends ContainerObjectSelectionList.Entry<DescriptionEntry> {
        protected FormattedCharSequence text;
        protected int indent;
        public boolean updateTextEntry = false;

        public DescriptionEntry(FormattedCharSequence text, int indent) {
            this.text = text;
            this.indent = indent;
        }

        public DescriptionEntry(FormattedCharSequence text) {
            this(text, 0);
        }

        public DescriptionEntry setUpdateTextEntry() {
            this.updateTextEntry = true;
            return this;
        }

        public void render(GuiGraphics DrawContext, int index, int y, int x, int itemWidth, int itemHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            if (this.updateTextEntry) {
                UpdateAvailableBadge.renderBadge(DrawContext, x + this.indent, y);
                x += 11;
            }
            DrawContext.drawString(DescriptionListWidget.this.textRenderer, this.text, x + this.indent, y, 0xAAAAAA);
        }

        public List<? extends GuiEventListener> children() {
            return Collections.emptyList();
        }

        public List<? extends NarratableEntry> narratables() {
            return Collections.emptyList();
        }
    }

    protected class LinkEntry
    extends DescriptionEntry {
        private final String link;

        public LinkEntry(FormattedCharSequence text, String link, int indent) {
            super(text, indent);
            this.link = link;
        }

        public LinkEntry(FormattedCharSequence text, String link) {
            this(text, link, 0);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.isMouseOver(mouseX, mouseY)) {
                DescriptionListWidget.this.minecraft.setScreen((Screen)new ConfirmLinkScreen(open -> {
                    if (open) {
                        Util.getPlatform().openUri(this.link);
                    }
                    DescriptionListWidget.this.minecraft.setScreen((Screen)DescriptionListWidget.this.parent);
                }, this.link, false));
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }
    }

    protected class MojangCreditsEntry
    extends DescriptionEntry {
        public MojangCreditsEntry(FormattedCharSequence text) {
            super(text);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.isMouseOver(mouseX, mouseY)) {
                DescriptionListWidget.this.minecraft.setScreen((Screen)new MinecraftCredits(this));
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }

        class MinecraftCredits
        extends CreditsAndAttributionScreen {
            public MinecraftCredits(MojangCreditsEntry this$1) {
                super((Screen)this$1.DescriptionListWidget.this.parent);
            }
        }
    }
}

