/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.terraformersmc.modmenu.ModMenu;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.gui.ModsScreen;
import com.terraformersmc.modmenu.gui.widget.entries.ChildEntry;
import com.terraformersmc.modmenu.gui.widget.entries.IndependentEntry;
import com.terraformersmc.modmenu.gui.widget.entries.ModListEntry;
import com.terraformersmc.modmenu.gui.widget.entries.ParentEntry;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.ModSearch;
import com.terraformersmc.modmenu.util.mod.fabric.FabricIconHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public class ModListWidget
extends ObjectSelectionList<ModListEntry>
implements AutoCloseable {
    public static final boolean DEBUG = Boolean.getBoolean("modmenu.debug");
    private final ModsScreen parent;
    private List<Mod> mods = null;
    private final Set<Mod> addedMods = new HashSet<Mod>();
    private String selectedModId = null;
    private boolean scrolling;
    private final FabricIconHandler iconHandler = new FabricIconHandler();

    public ModListWidget(Minecraft client, int width, int height, int y, int itemHeight, ModListWidget list, ModsScreen parent) {
        super(client, width, height, y, itemHeight);
        this.parent = parent;
        if (list != null) {
            this.mods = list.mods;
        }
    }

    public void setScrollAmount(double amount) {
        super.setScrollAmount(amount);
        int denominator = Math.max(0, this.getMaxPosition() - (this.getBottom() - this.getY() - 4));
        if (denominator <= 0) {
            this.parent.updateScrollPercent(0.0);
        } else {
            this.parent.updateScrollPercent(this.getScrollAmount() / (double)Math.max(0, this.getMaxPosition() - (this.getBottom() - this.getY() - 4)));
        }
    }

    public boolean isFocused() {
        return this.parent.getFocused() == this;
    }

    public void select(ModListEntry entry) {
        this.setSelected(entry);
        if (entry != null) {
            Mod mod = entry.getMod();
            this.minecraft.getNarrator().sayNow(Component.translatable((String)"narrator.select", (Object[])new Object[]{mod.getTranslatedName()}).getString());
        }
    }

    public void setSelected(ModListEntry entry) {
        super.setSelected((AbstractSelectionList.Entry)entry);
        this.selectedModId = entry.getMod().getId();
        this.parent.updateSelectedEntry((ModListEntry)this.getSelected());
    }

    protected boolean isSelectedItem(int index) {
        ModListEntry selected = (ModListEntry)this.getSelected();
        return selected != null && selected.getMod().getId().equals(((ModListEntry)this.getEntry(index)).getMod().getId());
    }

    public int addEntry(ModListEntry entry) {
        if (this.addedMods.contains(entry.mod)) {
            return 0;
        }
        this.addedMods.add(entry.mod);
        int i = super.addEntry((AbstractSelectionList.Entry)entry);
        if (entry.getMod().getId().equals(this.selectedModId)) {
            this.setSelected(entry);
        }
        return i;
    }

    protected boolean removeEntry(ModListEntry entry) {
        this.addedMods.remove(entry.mod);
        return super.removeEntry((AbstractSelectionList.Entry)entry);
    }

    protected ModListEntry remove(int index) {
        this.addedMods.remove(((ModListEntry)this.getEntry((int)index)).mod);
        return (ModListEntry)super.remove(index);
    }

    public void reloadFilters() {
        this.filter(this.parent.getSearchInput(), true, false);
    }

    public void filter(String searchTerm, boolean refresh) {
        this.filter(searchTerm, refresh, true);
    }

    private boolean hasVisibleChildMods(Mod parent) {
        List children = ModMenu.PARENT_MAP.get((Object)parent);
        boolean hideLibraries = !ModMenuConfig.SHOW_LIBRARIES.getValue();
        return !children.stream().allMatch(child -> child.isHidden() || hideLibraries && child.getBadges().contains((Object)Mod.Badge.LIBRARY));
    }

    private void filter(String searchTerm, boolean refresh, boolean search) {
        this.clearEntries();
        this.addedMods.clear();
        ArrayList mods = (ArrayList)((Object)ModMenu.MODS.values().stream().filter(mod -> {
            if (ModMenuConfig.CONFIG_MODE.getValue()) {
                return !this.parent.getModHasConfigScreen(mod.getId());
            }
            return !mod.isHidden();
        }).collect(Collectors.toSet()));
        if (DEBUG) {
            mods = new ArrayList(mods);
        }
        if (this.mods == null || refresh) {
            this.mods = new ArrayList<Mod>();
            this.mods.addAll(mods);
            this.mods.sort(ModMenuConfig.SORTING.getValue().getComparator());
        }
        List<Mod> matched = ModSearch.search(this.parent, searchTerm, this.mods);
        for (Mod mod2 : matched) {
            String modId = mod2.getId();
            if (mod2.getBadges().contains((Object)Mod.Badge.LIBRARY) && !ModMenuConfig.SHOW_LIBRARIES.getValue() || ModMenu.PARENT_MAP.values().contains(mod2)) continue;
            if (ModMenu.PARENT_MAP.keySet().contains(mod2) && this.hasVisibleChildMods(mod2)) {
                List children = ModMenu.PARENT_MAP.get((Object)mod2);
                children.sort(ModMenuConfig.SORTING.getValue().getComparator());
                ParentEntry parent = new ParentEntry(mod2, children, this);
                this.addEntry(parent);
                if (!this.parent.showModChildren.contains(modId)) continue;
                List<Mod> validChildren = ModSearch.search(this.parent, searchTerm, children);
                for (Mod child : validChildren) {
                    this.addEntry(new ChildEntry(child, parent, this, validChildren.indexOf(child) == validChildren.size() - 1));
                }
                continue;
            }
            this.addEntry(new IndependentEntry(mod2, this));
        }
        if (this.parent.getSelectedEntry() != null && !this.children().isEmpty() || this.getSelected() != null && ((ModListEntry)this.getSelected()).getMod() != this.parent.getSelectedEntry().getMod()) {
            for (ModListEntry entry : this.children()) {
                if (!entry.getMod().equals(this.parent.getSelectedEntry().getMod())) continue;
                this.setSelected(entry);
            }
        } else if (this.getSelected() == null && !this.children().isEmpty() && this.getEntry(0) != null) {
            this.setSelected((ModListEntry)this.getEntry(0));
        }
        if (this.getScrollAmount() > (double)Math.max(0, this.getMaxPosition() - (this.getBottom() - this.getY() - 4))) {
            this.setScrollAmount(Math.max(0, this.getMaxPosition() - (this.getBottom() - this.getY() - 4)));
        }
    }

    protected void renderListItems(GuiGraphics DrawContext, int mouseX, int mouseY, float delta) {
        int entryCount = this.getItemCount();
        Tesselator tessellator = Tesselator.getInstance();
        for (int index = 0; index < entryCount; ++index) {
            int entryLeft;
            int entryTop = this.getRowTop(index) + 2;
            int entryBottom = this.getRowTop(index) + this.itemHeight;
            if (entryBottom < this.getY() || entryTop > this.getBottom()) continue;
            int entryHeight = this.itemHeight - 4;
            ModListEntry entry = (ModListEntry)this.getEntry(index);
            int rowWidth = this.getRowWidth();
            if (this.isSelectedItem(index)) {
                MeshData builtBuffer;
                entryLeft = this.getRowLeft() - 2 + entry.getXOffset();
                int selectionRight = this.getRowLeft() + rowWidth + 2;
                float float_2 = this.isFocused() ? 1.0f : 0.5f;
                RenderSystem.setShader(GameRenderer::getPositionShader);
                RenderSystem.setShaderColor((float)float_2, (float)float_2, (float)float_2, (float)1.0f);
                Matrix4f matrix = DrawContext.pose().last().pose();
                BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
                buffer.addVertex(matrix, (float)entryLeft, (float)(entryTop + entryHeight + 2), 0.0f);
                buffer.addVertex(matrix, (float)selectionRight, (float)(entryTop + entryHeight + 2), 0.0f);
                buffer.addVertex(matrix, (float)selectionRight, (float)(entryTop - 2), 0.0f);
                buffer.addVertex(matrix, (float)entryLeft, (float)(entryTop - 2), 0.0f);
                try {
                    builtBuffer = buffer.buildOrThrow();
                    BufferUploader.drawWithShader((MeshData)builtBuffer);
                    builtBuffer.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                RenderSystem.setShader(GameRenderer::getPositionShader);
                RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                buffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
                buffer.addVertex(matrix, (float)(entryLeft + 1), (float)(entryTop + entryHeight + 1), 0.0f);
                buffer.addVertex(matrix, (float)(selectionRight - 1), (float)(entryTop + entryHeight + 1), 0.0f);
                buffer.addVertex(matrix, (float)(selectionRight - 1), (float)(entryTop - 1), 0.0f);
                buffer.addVertex(matrix, (float)(entryLeft + 1), (float)(entryTop - 1), 0.0f);
                try {
                    builtBuffer = buffer.buildOrThrow();
                    BufferUploader.drawWithShader((MeshData)builtBuffer);
                    builtBuffer.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            entryLeft = this.getRowLeft();
            entry.render(DrawContext, index, entryTop, entryLeft, rowWidth, entryHeight, mouseX, mouseY, this.isMouseOver(mouseX, mouseY) && Objects.equals((Object)this.getEntryAtPos(mouseX, mouseY), (Object)entry), delta);
        }
    }

    public void ensureVisible(ModListEntry entry) {
        super.ensureVisible((AbstractSelectionList.Entry)entry);
    }

    protected void updateScrollingState(double double_1, double double_2, int int_1) {
        super.updateScrollingState(double_1, double_2, int_1);
        this.scrolling = int_1 == 0 && double_1 >= (double)this.getScrollbarPosition() && double_1 < (double)(this.getScrollbarPosition() + 6);
    }

    public boolean mouseClicked(double double_1, double double_2, int int_1) {
        this.updateScrollingState(double_1, double_2, int_1);
        if (!this.isMouseOver(double_1, double_2)) {
            return false;
        }
        ModListEntry entry = this.getEntryAtPos(double_1, double_2);
        if (entry != null) {
            if (entry.mouseClicked(double_1, double_2, int_1)) {
                this.setFocused((GuiEventListener)entry);
                this.setDragging(true);
                return true;
            }
        } else if (int_1 == 0 && this.clickedHeader((int)(double_1 - (double)(this.getX() + this.width / 2 - this.getRowWidth() / 2)), (int)(double_2 - (double)this.getY()) + (int)this.getScrollAmount() - 4)) {
            return true;
        }
        return this.scrolling;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 265 || keyCode == 264) {
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        if (this.getSelected() != null) {
            return ((ModListEntry)this.getSelected()).keyPressed(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public final ModListEntry getEntryAtPos(double x, double y) {
        int int_5 = Mth.floor((double)(y - (double)this.getY())) - this.headerHeight + (int)this.getScrollAmount() - 4;
        int index = int_5 / this.itemHeight;
        return x < (double)this.getScrollbarPosition() && x >= (double)this.getRowLeft() && x <= (double)(this.getRowLeft() + this.getRowWidth()) && index >= 0 && int_5 >= 0 && index < this.getItemCount() ? (ModListEntry)((Object)this.children().get(index)) : null;
    }

    protected int getScrollbarPosition() {
        return this.width - 6;
    }

    public int getRowWidth() {
        return this.width - (Math.max(0, this.getMaxPosition() - (this.getBottom() - this.getY() - 4)) > 0 ? 18 : 12);
    }

    public int getRowLeft() {
        return this.getX() + 6;
    }

    public int getWidth() {
        return this.width;
    }

    public int getTop() {
        return this.getY();
    }

    public ModsScreen getParent() {
        return this.parent;
    }

    protected int getMaxPosition() {
        return super.getMaxPosition() + 4;
    }

    public int getDisplayedCountFor(Set<String> set) {
        int count = 0;
        for (ModListEntry c : this.children()) {
            if (!set.contains(c.getMod().getId())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void close() {
        this.iconHandler.close();
    }

    public FabricIconHandler getFabricIconHandler() {
        return this.iconHandler;
    }
}

