/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.gui.widget.entries;

import com.mojang.blaze3d.systems.RenderSystem;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.gui.widget.ModListWidget;
import com.terraformersmc.modmenu.gui.widget.UpdateAvailableBadge;
import com.terraformersmc.modmenu.gui.widget.entries.ParentEntry;
import com.terraformersmc.modmenu.util.DrawingUtil;
import com.terraformersmc.modmenu.util.ModMenuScreenTexts;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.ModBadgeRenderer;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ModListEntry
extends ObjectSelectionList.Entry<ModListEntry> {
    public static final ResourceLocation UNKNOWN_ICON = ResourceLocation.withDefaultNamespace((String)"textures/misc/unknown_pack.png");
    private static final ResourceLocation MOD_CONFIGURATION_ICON = ResourceLocation.fromNamespaceAndPath((String)"modmenu", (String)"textures/gui/mod_configuration.png");
    private static final ResourceLocation ERROR_ICON = ResourceLocation.withDefaultNamespace((String)"world_list/error");
    private static final ResourceLocation ERROR_HIGHLIGHTED_ICON = ResourceLocation.withDefaultNamespace((String)"world_list/error_highlighted");
    protected final Minecraft client;
    public final Mod mod;
    protected final ModListWidget list;
    protected ResourceLocation iconLocation;
    protected static final int FULL_ICON_SIZE = 32;
    protected static final int COMPACT_ICON_SIZE = 19;
    protected long sinceLastClick;

    public ModListEntry(Mod mod, ModListWidget list) {
        this.mod = mod;
        this.list = list;
        this.client = Minecraft.getInstance();
    }

    public Component getNarration() {
        return Component.literal((String)this.mod.getTranslatedName());
    }

    public void render(GuiGraphics DrawContext, int index, int y, int x, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float delta) {
        MutableComponent name;
        x += this.getXOffset();
        rowWidth -= this.getXOffset();
        int iconSize = ModMenuConfig.COMPACT_LIST.getValue() ? 19 : 32;
        String modId = this.mod.getId();
        if ("java".equals(modId)) {
            DrawingUtil.drawRandomVersionBackground(this.mod, DrawContext, x, y, iconSize, iconSize);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        DrawContext.blit(this.getIconTexture(), x, y, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
        RenderSystem.disableBlend();
        MutableComponent trimmedName = name = Component.literal((String)this.mod.getTranslatedName());
        int maxNameWidth = rowWidth - iconSize - 3;
        Font font = this.client.font;
        if (font.width((FormattedText)name) > maxNameWidth) {
            FormattedText ellipsis = FormattedText.of((String)"...");
            trimmedName = FormattedText.composite((FormattedText[])new FormattedText[]{font.substrByWidth((FormattedText)name, maxNameWidth - font.width(ellipsis)), ellipsis});
        }
        DrawContext.drawString(font, Language.getInstance().getVisualOrder((FormattedText)trimmedName), x + iconSize + 3, y + 1, 0xFFFFFF, true);
        int updateBadgeXOffset = 0;
        if (ModMenuConfig.UPDATE_CHECKER.getValue() && !ModMenuConfig.DISABLE_UPDATE_CHECKER.getValue().contains(modId) && (this.mod.hasUpdate() || this.mod.getChildHasUpdate())) {
            UpdateAvailableBadge.renderBadge(DrawContext, x + iconSize + 3 + font.width((FormattedText)name) + 2, y);
            updateBadgeXOffset = 11;
        }
        if (!ModMenuConfig.HIDE_BADGES.getValue()) {
            new ModBadgeRenderer(x + iconSize + 3 + font.width((FormattedText)name) + 2 + updateBadgeXOffset, y, x + rowWidth, this.mod, this.list.getParent()).draw(DrawContext, mouseX, mouseY);
        }
        if (!ModMenuConfig.COMPACT_LIST.getValue()) {
            String summary = this.mod.getSummary();
            Objects.requireNonNull(this.client.font);
            DrawingUtil.drawWrappedString(DrawContext, summary, x + iconSize + 3 + 4, y + 9 + 2, rowWidth - iconSize - 7, 2, 0x808080);
        } else {
            String string = this.mod.getPrefixedVersion();
            Objects.requireNonNull(this.client.font);
            DrawingUtil.drawWrappedString(DrawContext, string, x + iconSize + 3, y + 9 + 2, rowWidth - iconSize - 7, 2, 0x808080);
        }
        if (!(this instanceof ParentEntry) && ModMenuConfig.QUICK_CONFIGURE.getValue() && (this.list.getParent().getModHasConfigScreen(modId) || this.list.getParent().modScreenErrors.containsKey(modId))) {
            int textureSize;
            int n = textureSize = ModMenuConfig.COMPACT_LIST.getValue() ? 152 : 256;
            if (((Boolean)this.client.options.touchscreen().get()).booleanValue() || hovered) {
                boolean hoveringIcon;
                DrawContext.fill(x, y, x + iconSize, y + iconSize, -1601138544);
                boolean bl = hoveringIcon = mouseX - x < iconSize;
                if (this.list.getParent().modScreenErrors.containsKey(modId)) {
                    DrawContext.blitSprite(hoveringIcon ? ERROR_HIGHLIGHTED_ICON : ERROR_ICON, x, y, iconSize, iconSize);
                    if (hoveringIcon) {
                        Throwable e = this.list.getParent().modScreenErrors.get(modId);
                        this.list.getParent().setTooltipForNextRenderPass(this.client.font.split((FormattedText)ModMenuScreenTexts.configureError(modId, e), 175));
                    }
                } else {
                    int v = hoveringIcon ? iconSize : 0;
                    DrawContext.blit(MOD_CONFIGURATION_ICON, x, y, 0.0f, (float)v, iconSize, iconSize, textureSize, textureSize);
                }
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int delta) {
        this.list.select(this);
        if (ModMenuConfig.QUICK_CONFIGURE.getValue() && this.list.getParent().getModHasConfigScreen(this.mod.getId())) {
            int iconSize;
            int n = iconSize = ModMenuConfig.COMPACT_LIST.getValue() ? 19 : 32;
            if (mouseX - (double)this.list.getRowLeft() <= (double)iconSize) {
                this.openConfig();
            } else if (Util.getMillis() - this.sinceLastClick < 250L) {
                this.openConfig();
            }
        }
        this.sinceLastClick = Util.getMillis();
        return true;
    }

    public void openConfig() {
        this.list.getParent().safelyOpenConfigScreen(this.mod.getId());
    }

    public Mod getMod() {
        return this.mod;
    }

    public ResourceLocation getIconTexture() {
        if (this.iconLocation == null) {
            this.iconLocation = ResourceLocation.fromNamespaceAndPath((String)"modmenu", (String)(this.mod.getId() + "_icon"));
            DynamicTexture icon = this.mod.getIcon(this.list.getFabricIconHandler(), 64 * (Integer)this.client.options.guiScale().get());
            if (icon != null) {
                this.client.getTextureManager().register(this.iconLocation, (AbstractTexture)icon);
            } else {
                this.iconLocation = UNKNOWN_ICON;
            }
        }
        return this.iconLocation;
    }

    public int getXOffset() {
        return 0;
    }
}

