/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.mixin;

import com.terraformersmc.modmenu.api.ModMenuApi;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.event.ModMenuEventHandler;
import com.terraformersmc.modmenu.gui.ModsScreen;
import com.terraformersmc.modmenu.gui.widget.ModMenuButtonWidget;
import com.terraformersmc.modmenu.gui.widget.UpdateCheckerTexturedButtonWidget;
import com.terraformersmc.modmenu.mixin.AccessorGridWidget;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={PauseScreen.class})
public abstract class MixinGameMenu
extends Screen {
    protected MixinGameMenu(Component title) {
        super(title);
    }

    @Inject(method={"initWidgets"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/widget/GridWidget;forEachChild(Ljava/util/function/Consumer;)V")}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private void onInitWidgets(CallbackInfo ci, GridLayout gridWidget) {
        block11: {
            if (gridWidget == null) break block11;
            List<LayoutElement> buttons = ((AccessorGridWidget)gridWidget).getChildren();
            if (!ModMenuConfig.MODIFY_GAME_MENU.getValue()) break block11;
            int modsButtonIndex = -1;
            int spacing = 24;
            int buttonsY = this.height / 4 + 8;
            ModMenuConfig.GameMenuButtonStyle style = ModMenuConfig.GAME_MENU_BUTTON_STYLE.getValue();
            int vanillaButtonsY = this.height / 4 + 72 - 16 + 1;
            int fullWidthButton = 204;
            for (int i = 0; i < buttons.size(); ++i) {
                LayoutElement widget;
                block12: {
                    block13: {
                        widget = buttons.get(i);
                        if (style != ModMenuConfig.GameMenuButtonStyle.INSERT) break block12;
                        if (!(widget instanceof AbstractWidget)) break block13;
                        AbstractWidget button2 = (AbstractWidget)widget;
                        if (!button2.visible) break block12;
                    }
                    ModMenuEventHandler.shiftButtons(widget, modsButtonIndex == -1 || ModMenuEventHandler.buttonHasText(widget, "menu.reportBugs", "menu.server_links"), 24);
                    if (modsButtonIndex == -1) {
                        buttonsY = widget.getY();
                    }
                }
                boolean isShortFeedback = ModMenuEventHandler.buttonHasText(widget, "menu.feedback");
                boolean isLongFeedback = ModMenuEventHandler.buttonHasText(widget, "menu.sendFeedback");
                if (!isShortFeedback && !isLongFeedback) continue;
                modsButtonIndex = i + 1;
                vanillaButtonsY = widget.getY();
                if (style == ModMenuConfig.GameMenuButtonStyle.REPLACE) {
                    buttons.set(i, (LayoutElement)new ModMenuButtonWidget(widget.getX(), widget.getY(), isShortFeedback ? widget.getWidth() : 204, widget.getHeight(), ModMenuApi.createModsButtonText(), this));
                    buttons.stream().filter(w -> ModMenuEventHandler.buttonHasText(w, "menu.reportBugs")).forEach(w -> {
                        if (w instanceof AbstractWidget) {
                            AbstractWidget cw = (AbstractWidget)w;
                            cw.visible = false;
                            cw.active = false;
                        }
                    });
                    continue;
                }
                modsButtonIndex = i + 1;
                if (widget instanceof AbstractWidget) {
                    AbstractWidget button3 = (AbstractWidget)widget;
                    if (!button3.visible) continue;
                }
                buttonsY = widget.getY();
            }
            if (modsButtonIndex != -1) {
                if (style == ModMenuConfig.GameMenuButtonStyle.INSERT) {
                    buttons.add(modsButtonIndex, (LayoutElement)new ModMenuButtonWidget(this.width / 2 - 102, buttonsY + 24, 204, 20, ModMenuApi.createModsButtonText(), this));
                } else if (style == ModMenuConfig.GameMenuButtonStyle.ICON) {
                    buttons.add(modsButtonIndex, (LayoutElement)new UpdateCheckerTexturedButtonWidget(this.width / 2 + 4 + 100 + 2, vanillaButtonsY, 20, 20, 0, 0, 20, ModMenuEventHandler.MODS_BUTTON_TEXTURE, 32, 64, button -> Minecraft.getInstance().setScreen((Screen)new ModsScreen(this)), ModMenuApi.createModsButtonText()));
                }
            }
        }
    }
}

