/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.util.mod.Mod;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

@Environment(value=EnvType.CLIENT)
public class DrawingUtil {
    private static final Minecraft CLIENT = Minecraft.getInstance();

    public static void drawRandomVersionBackground(Mod mod, GuiGraphics DrawContext, int x, int y, int width, int height) {
        int seed = mod.getName().hashCode() + mod.getVersion().hashCode();
        Random random = new Random(seed);
        int color = 0xFF000000 | Mth.hsvToRgb((float)random.nextFloat(1.0f), (float)random.nextFloat(0.7f, 0.8f), (float)0.9f);
        if (!ModMenuConfig.RANDOM_JAVA_COLORS.getValue()) {
            color = -2271658;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        DrawContext.fill(x, y, x + width, y + height, color);
    }

    public static void drawWrappedString(GuiGraphics DrawContext, String string, int x, int y, int wrapWidth, int lines, int color) {
        while (string != null && string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        List strings = DrawingUtil.CLIENT.font.getSplitter().splitLines((FormattedText)Component.literal((String)string), wrapWidth, Style.EMPTY);
        for (int i = 0; i < strings.size() && i < lines; ++i) {
            FormattedText renderable = (FormattedText)strings.get(i);
            if (i == lines - 1 && strings.size() > lines) {
                renderable = FormattedText.composite((FormattedText[])new FormattedText[]{(FormattedText)strings.get(i), FormattedText.of((String)"...")});
            }
            FormattedCharSequence line = Language.getInstance().getVisualOrder(renderable);
            int x1 = x;
            if (DrawingUtil.CLIENT.font.isBidirectional()) {
                int width = DrawingUtil.CLIENT.font.width(line);
                x1 = (int)((float)x1 + (float)(wrapWidth - width));
            }
            Font font = DrawingUtil.CLIENT.font;
            Objects.requireNonNull(DrawingUtil.CLIENT.font);
            DrawContext.drawString(font, line, x1, y + i * 9, color, true);
        }
    }

    public static void drawBadge(GuiGraphics DrawContext, int x, int y, int tagWidth, FormattedCharSequence text, int outlineColor, int fillColor, int textColor) {
        DrawContext.fill(x + 1, y - 1, x + tagWidth, y, outlineColor);
        Objects.requireNonNull(DrawingUtil.CLIENT.font);
        DrawContext.fill(x, y, x + 1, y + 9, outlineColor);
        Objects.requireNonNull(DrawingUtil.CLIENT.font);
        Objects.requireNonNull(DrawingUtil.CLIENT.font);
        DrawContext.fill(x + 1, y + 1 + 9 - 1, x + tagWidth, y + 9 + 1, outlineColor);
        Objects.requireNonNull(DrawingUtil.CLIENT.font);
        DrawContext.fill(x + tagWidth, y, x + tagWidth + 1, y + 9, outlineColor);
        Objects.requireNonNull(DrawingUtil.CLIENT.font);
        DrawContext.fill(x + 1, y, x + tagWidth, y + 9, fillColor);
        DrawContext.drawString(DrawingUtil.CLIENT.font, text, (int)((float)(x + 1) + (float)(tagWidth - DrawingUtil.CLIENT.font.width(text)) / 2.0f), y + 1, textColor, false);
    }
}

