/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.util;

import com.terraformersmc.modmenu.ModMenu;
import com.terraformersmc.modmenu.util.VersionUtil;
import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.SharedConstants;

public class HttpUtil {
    private static final String USER_AGENT = HttpUtil.buildUserAgent();
    private static final HttpClient HTTP_CLIENT = HttpClient.newHttpClient();

    private HttpUtil() {
    }

    public static <T> HttpResponse<T> request(HttpRequest.Builder builder, HttpResponse.BodyHandler<T> handler) throws IOException, InterruptedException {
        builder.setHeader("User-Agent", USER_AGENT);
        return HTTP_CLIENT.send(builder.build(), handler);
    }

    private static String buildUserAgent() {
        String env = ModMenu.DEV_ENVIRONMENT ? "/development" : "";
        String loader = ModMenu.RUNNING_QUILT ? "quilt" : "fabric";
        String modMenuVersion = HttpUtil.getModMenuVersion();
        String minecraftVersion = SharedConstants.getCurrentVersion().getName();
        return "%s/%s (%s/%s%s)".formatted("TerraformersMC/ModMenu", modMenuVersion, minecraftVersion, loader, env);
    }

    private static String getModMenuVersion() {
        Optional container = FabricLoader.getInstance().getModContainer("modmenu");
        if (container.isEmpty()) {
            throw new RuntimeException("Unable to find Modmenu's own mod container!");
        }
        return VersionUtil.removeBuildMetadata(((ModContainer)container.get()).getMetadata().getVersion().getFriendlyString());
    }
}

