/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.util.mod;

import com.terraformersmc.modmenu.ModMenu;
import com.terraformersmc.modmenu.TextPlaceholderApiCompat;
import com.terraformersmc.modmenu.api.UpdateChecker;
import com.terraformersmc.modmenu.api.UpdateInfo;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.util.mod.fabric.FabricIconHandler;
import eu.pb4.placeholders.api.ParserContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Mod {
    @NotNull
    public String getId();

    @NotNull
    public String getName();

    @NotNull
    default public String getTranslatedName() {
        String translationKey = "modmenu.nameTranslation." + this.getId();
        if ((this.getId().equals("minecraft") || this.getId().equals("java") || ModMenuConfig.TRANSLATE_NAMES.getValue()) && I18n.exists((String)translationKey)) {
            return I18n.get((String)translationKey, (Object[])new Object[0]);
        }
        return this.getName();
    }

    @NotNull
    public DynamicTexture getIcon(FabricIconHandler var1, int var2);

    @NotNull
    default public String getSummary() {
        String string = this.getTranslatedSummary();
        return ModMenu.TEXT_PLACEHOLDER_COMPAT ? TextPlaceholderApiCompat.PARSER.parseText(string, ParserContext.of()).getString() : string;
    }

    @NotNull
    default public String getTranslatedSummary() {
        String translationKey = "modmenu.summaryTranslation." + this.getId();
        if ((this.getId().equals("minecraft") || this.getId().equals("java") || ModMenuConfig.TRANSLATE_DESCRIPTIONS.getValue()) && I18n.exists((String)translationKey)) {
            return I18n.get((String)translationKey, (Object[])new Object[0]);
        }
        return this.getTranslatedDescription();
    }

    @NotNull
    public String getDescription();

    @NotNull
    default public String getTranslatedDescription() {
        String translatableDescriptionKey = "modmenu.descriptionTranslation." + this.getId();
        if ((this.getId().equals("minecraft") || this.getId().equals("java") || ModMenuConfig.TRANSLATE_DESCRIPTIONS.getValue()) && I18n.exists((String)translatableDescriptionKey)) {
            return I18n.get((String)translatableDescriptionKey, (Object[])new Object[0]);
        }
        return this.getDescription();
    }

    default public Component getFormattedDescription() {
        String string = this.getTranslatedDescription();
        return ModMenu.TEXT_PLACEHOLDER_COMPAT ? TextPlaceholderApiCompat.PARSER.parseText(string, ParserContext.of()) : Component.literal((String)string);
    }

    @NotNull
    public String getVersion();

    @NotNull
    public String getPrefixedVersion();

    @NotNull
    public List<String> getAuthors();

    @NotNull
    public Map<String, Collection<String>> getContributors();

    @NotNull
    public SortedMap<String, Set<String>> getCredits();

    @NotNull
    public Set<Badge> getBadges();

    @Nullable
    public String getWebsite();

    @Nullable
    public String getIssueTracker();

    @Nullable
    public String getSource();

    @Nullable
    public String getParent();

    @NotNull
    public Set<String> getLicense();

    @NotNull
    public Map<String, String> getLinks();

    public boolean isReal();

    public boolean allowsUpdateChecks();

    @Nullable
    public UpdateChecker getUpdateChecker();

    public void setUpdateChecker(@Nullable UpdateChecker var1);

    @Nullable
    public UpdateInfo getUpdateInfo();

    public void setUpdateInfo(@Nullable UpdateInfo var1);

    default public boolean hasUpdate() {
        UpdateInfo updateInfo = this.getUpdateInfo();
        if (updateInfo == null) {
            return false;
        }
        return updateInfo.isUpdateAvailable() && updateInfo.getUpdateChannel().compareTo(ModMenuConfig.UPDATE_CHANNEL.getValue()) >= 0;
    }

    @Nullable
    default public String getSha512Hash() throws IOException {
        return null;
    }

    public void setChildHasUpdate();

    public boolean getChildHasUpdate();

    public boolean isHidden();

    public static enum Badge {
        LIBRARY("modmenu.badge.library", -15698860, -16172759, "library"),
        CLIENT("modmenu.badge.clientsideOnly", -13939844, -15848875, null),
        DEPRECATED("modmenu.badge.deprecated", -8121306, -11334633, "deprecated"),
        PATCHWORK_FORGE("modmenu.badge.forge", -14734014, -15722719, null),
        MODPACK("modmenu.badge.modpack", -8770692, -11465388, null),
        MINECRAFT("modmenu.badge.minecraft", -9474966, -13553617, null);

        private final Component text;
        private final int outlineColor;
        private final int fillColor;
        private final String key;
        private static final Map<String, Badge> KEY_MAP;

        private Badge(String translationKey, int outlineColor, int fillColor, String key) {
            this.text = Component.translatable((String)translationKey);
            this.outlineColor = outlineColor;
            this.fillColor = fillColor;
            this.key = key;
        }

        public Component getText() {
            return this.text;
        }

        public int getOutlineColor() {
            return this.outlineColor;
        }

        public int getFillColor() {
            return this.fillColor;
        }

        public static Set<Badge> convert(Set<String> badgeKeys, String modId) {
            return badgeKeys.stream().map(key -> {
                if (!KEY_MAP.containsKey(key)) {
                    ModMenu.LOGGER.warn("Skipping unknown badge key '{}' specified by mod '{}'", key, (Object)modId);
                }
                return KEY_MAP.get(key);
            }).filter(Objects::nonNull).collect(Collectors.toSet());
        }

        static {
            KEY_MAP = new HashMap<String, Badge>();
            Arrays.stream(Badge.values()).forEach(badge -> KEY_MAP.put(badge.key, (Badge)((Object)badge)));
        }
    }
}

