/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.util.mod;

import com.terraformersmc.modmenu.gui.ModsScreen;
import com.terraformersmc.modmenu.util.DrawingUtil;
import com.terraformersmc.modmenu.util.mod.Mod;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.FormattedCharSequence;

public class ModBadgeRenderer {
    protected int startX;
    protected int startY;
    protected int badgeX;
    protected int badgeY;
    protected int badgeMax;
    protected Mod mod;
    protected Minecraft client;
    protected final ModsScreen screen;

    public ModBadgeRenderer(int startX, int startY, int endX, Mod mod, ModsScreen screen) {
        this.startX = startX;
        this.startY = startY;
        this.badgeMax = endX;
        this.mod = mod;
        this.screen = screen;
        this.client = Minecraft.getInstance();
    }

    public void draw(GuiGraphics DrawContext, int mouseX, int mouseY) {
        this.badgeX = this.startX;
        this.badgeY = this.startY;
        Set<Mod.Badge> badges = this.mod.getBadges();
        badges.forEach(badge -> this.drawBadge(DrawContext, (Mod.Badge)((Object)badge), mouseX, mouseY));
    }

    public void drawBadge(GuiGraphics DrawContext, Mod.Badge badge, int mouseX, int mouseY) {
        this.drawBadge(DrawContext, badge.getText().getVisualOrderText(), badge.getOutlineColor(), badge.getFillColor(), mouseX, mouseY);
    }

    public void drawBadge(GuiGraphics DrawContext, FormattedCharSequence text, int outlineColor, int fillColor, int mouseX, int mouseY) {
        int width = this.client.font.width(text) + 6;
        if (this.badgeX + width < this.badgeMax) {
            DrawingUtil.drawBadge(DrawContext, this.badgeX, this.badgeY, width, text, outlineColor, fillColor, 0xCACACA);
            this.badgeX += width + 3;
        }
    }

    public Mod getMod() {
        return this.mod;
    }
}

