/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.util.mod;

import com.terraformersmc.modmenu.api.UpdateChannel;
import com.terraformersmc.modmenu.api.UpdateInfo;
import com.terraformersmc.modmenu.util.VersionUtil;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class ModrinthUpdateInfo
implements UpdateInfo {
    protected final String projectId;
    protected final String versionId;
    protected final String versionNumber;
    protected final UpdateChannel updateChannel;
    private static final Component MODRINTH_TEXT = Component.translatable((String)"modmenu.modrinth");

    public ModrinthUpdateInfo(String projectId, String versionId, String versionNumber, UpdateChannel updateChannel) {
        this.projectId = projectId;
        this.versionId = versionId;
        this.versionNumber = versionNumber;
        this.updateChannel = updateChannel;
    }

    @Override
    public boolean isUpdateAvailable() {
        return true;
    }

    @Override
    @Nullable
    public Component getUpdateMessage() {
        return Component.translatable((String)"modmenu.updateText", (Object[])new Object[]{VersionUtil.stripPrefix(this.versionNumber), MODRINTH_TEXT});
    }

    @Override
    public String getDownloadLink() {
        return "https://modrinth.com/project/%s/version/%s".formatted(this.projectId, this.versionId);
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public String getVersionNumber() {
        return this.versionNumber;
    }

    @Override
    public UpdateChannel getUpdateChannel() {
        return this.updateChannel;
    }
}

