/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.util.mod.fabric;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricIconHandler
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Mod Menu | FabricIconHandler");
    private final Map<Path, DynamicTexture> modIconCache = new HashMap<Path, DynamicTexture>();

    public DynamicTexture createIcon(ModContainer iconSource, String iconPath) {
        DynamicTexture dynamicTexture;
        block13: {
            Path path = iconSource.getPath(iconPath);
            DynamicTexture cachedIcon = this.getCachedModIcon(path);
            if (cachedIcon != null) {
                return cachedIcon;
            }
            cachedIcon = this.getCachedModIcon(path);
            if (cachedIcon != null) {
                return cachedIcon;
            }
            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
            try {
                NativeImage image = NativeImage.read((InputStream)Objects.requireNonNull(inputStream));
                Validate.validState((image.getHeight() == image.getWidth() ? 1 : 0) != 0, (String)"Must be square icon", (Object[])new Object[0]);
                DynamicTexture tex = new DynamicTexture(image);
                this.cacheModIcon(path, tex);
                dynamicTexture = tex;
                if (inputStream == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalStateException e) {
                    if (e.getMessage().equals("Must be square icon")) {
                        LOGGER.error("Mod icon must be a square for icon source {}: {}", new Object[]{iconSource.getMetadata().getId(), iconPath, e});
                    }
                    return null;
                }
                catch (Throwable t) {
                    if (!iconPath.equals("assets/" + iconSource.getMetadata().getId() + "/icon.png")) {
                        LOGGER.error("Invalid mod icon for icon source {}: {}", new Object[]{iconSource.getMetadata().getId(), iconPath, t});
                    }
                    return null;
                }
            }
            inputStream.close();
        }
        return dynamicTexture;
    }

    @Override
    public void close() {
        for (DynamicTexture tex : this.modIconCache.values()) {
            tex.close();
        }
    }

    DynamicTexture getCachedModIcon(Path path) {
        return this.modIconCache.get(path);
    }

    void cacheModIcon(Path path, DynamicTexture tex) {
        this.modIconCache.put(path, tex);
    }
}

