/*
 * Decompiled with CFR 0.152.
 */
package leah.leahs_immersive_thunder.mixin;

import java.util.Objects;
import leah.leahs_immersive_thunder.ImmersiveThunderClient;
import leah.leahs_immersive_thunder.config.ImmersiveThunderConfig;
import leah.leahs_immersive_thunder.util.ThunderSoundInterface;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={LightningBolt.class})
public class ImmersiveThunderMixin
implements ThunderSoundInterface {
    @Unique
    ImmersiveThunderConfig config = (ImmersiveThunderConfig)ImmersiveThunderClient.configHolder.getConfig();

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;playSound(DDDLnet/minecraft/sound/SoundEvent;Lnet/minecraft/sound/SoundCategory;FFZ)V"))
    private void playSound(Level world, double x, double y, double z, SoundEvent sound, SoundSource category, float volume, float pitch, boolean useDistance) {
        LightningBolt lightning = (LightningBolt)this;
        LocalPlayer player = Minecraft.getInstance().player;
        double distanceToEntity = ((Player)Objects.requireNonNull(player)).distanceTo((Entity)lightning);
        if (distanceToEntity <= 90.0) {
            this.playThunderSound(world, lightning, ImmersiveThunderClient.ENTITY_LIGHTNING_BOLT_THUNDER_CLOSE, 5000.0f, false);
        } else if (distanceToEntity <= 140.0) {
            this.playThunderSound(world, lightning, ImmersiveThunderClient.ENTITY_LIGHTNING_BOLT_THUNDER_MEDIUM, 10000.0f, true);
        } else {
            this.playThunderSound(world, lightning, ImmersiveThunderClient.ENTITY_LIGHTNING_BOLT_THUNDER_FAR, 10000.0f, true);
        }
    }

    @Override
    public void playThunderSound(Level world, LightningBolt lightning, SoundEvent soundEvent, float volume, boolean useDistance) {
        world.playLocalSound(lightning.getX(), lightning.getY(), lightning.getZ(), soundEvent, SoundSource.WEATHER, volume, 0.8f + world.random.nextFloat() * 0.2f, useDistance);
        if (this.config.impactSound) {
            world.playLocalSound(lightning.getX(), lightning.getY(), lightning.getZ(), SoundEvents.LIGHTNING_BOLT_IMPACT, SoundSource.WEATHER, 2.0f, 0.5f + world.random.nextFloat() * 0.2f, false);
        }
    }
}

