/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.firstperson.mixins;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.tr7zw.firstperson.FirstPersonModelCore;
import dev.tr7zw.firstperson.util.NMSHelper;
import dev.tr7zw.firstperson.versionless.config.VanillaHands;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemInHandRenderer.class})
public abstract class HeldItemRendererMixin {
    @Shadow
    private EntityRenderDispatcher entityRenderDispatcher;
    @Shadow
    private float mainHandHeight;
    @Shadow
    private float offHandHeight;
    @Shadow
    private ItemStack mainHandItem;
    @Shadow
    private ItemStack offHandItem;

    @Inject(at={@At(value="HEAD")}, method={"renderArmWithItem(Lnet/minecraft/client/player/AbstractClientPlayer;FFLnet/minecraft/world/InteractionHand;FLnet/minecraft/world/item/ItemStack;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, cancellable=true)
    public void renderFirstPersonItem(AbstractClientPlayer player, float tickDelta, float pitch, InteractionHand hand, float swingProgress, ItemStack item, float equipProgress, PoseStack matrices, MultiBufferSource vertexConsumers, int light, CallbackInfo info) {
        if (!FirstPersonModelCore.instance.isEnabled()) {
            return;
        }
        if (!FirstPersonModelCore.instance.getLogicHandler().showVanillaHands()) {
            info.cancel();
            return;
        }
        if (FirstPersonModelCore.instance.getConfig().vanillaHandsSkipSwimming && FirstPersonModelCore.instance.getLogicHandler().isSwimming((Player)player)) {
            info.cancel();
            return;
        }
        if (FirstPersonModelCore.instance.getLogicHandler().dynamicHandsEnabled() && pitch > 35.0f) {
            info.cancel();
            return;
        }
        if (FirstPersonModelCore.instance.getConfig().vanillaHandsMode != VanillaHands.ALL_DOUBLE || player.getMainHandItem().getItem() == Items.FILLED_MAP || player.isScoping()) {
            return;
        }
        boolean bl = hand == InteractionHand.MAIN_HAND;
        HumanoidArm arm = bl ? player.getMainArm() : player.getMainArm().getOpposite();
        matrices.pushPose();
        if (item.isEmpty() && !bl && !player.isInvisible()) {
            this.renderPlayerArm(matrices, vertexConsumers, light, equipProgress, swingProgress, arm);
        }
        matrices.popPose();
    }

    @Shadow
    public abstract void renderPlayerArm(PoseStack var1, MultiBufferSource var2, int var3, float var4, float var5, HumanoidArm var6);

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;getAttackStrengthScale(F)F", shift=At.Shift.BEFORE)}, method={"tick()V"}, cancellable=true)
    public void tick(CallbackInfo ci) {
        LocalPlayer localPlayer;
        float f;
        if (FirstPersonModelCore.instance.isEnabled() && FirstPersonModelCore.instance.getLogicHandler().showVanillaHands() && FirstPersonModelCore.instance.getLogicHandler().dynamicHandsEnabled() && (f = NMSHelper.getXRot((Entity)(localPlayer = Minecraft.getInstance().player))) > 15.0f) {
            if (f < 30.0f) {
                this.mainHandHeight = 15.0f / f;
                this.offHandHeight = 15.0f / f;
            } else {
                this.mainHandHeight -= this.mainHandHeight > -0.1f ? 0.15f : 0.0f;
                this.offHandHeight -= this.offHandHeight > -0.1f ? 0.15f : 0.0f;
            }
            ci.cancel();
            this.mainHandItem = localPlayer.getMainHandItem();
            this.offHandItem = localPlayer.getOffhandItem();
        }
    }
}

