/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.firstperson.mixins;

import dev.tr7zw.firstperson.FirstPersonModelCore;
import dev.tr7zw.firstperson.api.FirstPersonAPI;
import dev.tr7zw.firstperson.api.PlayerOffsetHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerRenderer.class}, priority=500)
public class PlayerRendererMixin {
    private static Minecraft fpmMcInstance = Minecraft.getInstance();

    @Inject(method={"getRenderOffset(Lnet/minecraft/client/player/AbstractClientPlayer;F)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="RETURN")}, cancellable=true)
    public void getRenderOffset(AbstractClientPlayer entity, float delta, CallbackInfoReturnable<Vec3> ci) {
        if (entity == PlayerRendererMixin.fpmMcInstance.cameraEntity && FirstPersonModelCore.instance.isRenderingPlayer()) {
            FirstPersonModelCore.instance.getLogicHandler().updatePositionOffset((Entity)entity, delta);
            Vec3 offset = ((Vec3)ci.getReturnValue()).add(FirstPersonModelCore.instance.getLogicHandler().getOffset());
            for (PlayerOffsetHandler handler : FirstPersonAPI.getPlayerOffsetHandlers()) {
                offset = handler.applyOffset(entity, delta, (Vec3)ci.getReturnValue(), offset);
            }
            ci.setReturnValue((Object)offset);
        }
    }
}

