/*
 * Decompiled with CFR 0.152.
 */
package net.countered.terrainslabs.worldgen.slabfeature;

import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Set;
import net.countered.terrainslabs.block.ModBlocksRegistry;
import net.countered.terrainslabs.block.ModSlabsMap;
import net.countered.terrainslabs.block.customslabs.specialslabs.CustomSlab;
import net.countered.terrainslabs.config.MyModConfig;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2482;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_5281;
import net.minecraft.class_5821;

public class SlabFeatureLogic
extends class_3031<class_3111> {
    public static final Set<class_2248> VALID_BLOCKS_FOR_SLAB_PLACEMENT = new HashSet<class_2248>();
    private static final Set<class_2248> SOIL_SLAB_BLOCKS;

    public SlabFeatureLogic(Codec<class_3111> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<class_3111> context) {
        if (MyModConfig.enableSlabGeneration) {
            return this.runLogic(context);
        }
        return false;
    }

    private boolean runLogic(class_5821<class_3111> context) {
        class_5281 world = context.method_33652();
        class_2338 origin = context.method_33655();
        class_1923 chunkPos = new class_1923(origin);
        class_2338.class_2339 highestBlock = new class_2338.class_2339(0, 0, 0);
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int x = chunkPos.method_8326(); x <= chunkPos.method_8327(); ++x) {
            for (int z = chunkPos.method_8328(); z <= chunkPos.method_8329(); ++z) {
                pos.method_10103(x, 0, z);
                if (!world.method_8393(chunkPos.field_9181, chunkPos.field_9180)) continue;
                class_2338 topPosition = world.method_8598(class_2902.class_2903.field_13194, (class_2338)pos);
                if (highestBlock.method_10264() >= topPosition.method_10264()) continue;
                highestBlock = topPosition;
            }
        }
        for (int y = world.method_31607(); y < highestBlock.method_10264() + 1; ++y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    class_2680 slabState;
                    class_2680 currentBlockState;
                    class_2338 currentPos = chunkPos.method_35231(x, y, z);
                    class_2338 blockBelowPos = currentPos.method_10074();
                    class_2338 blockAbovePos = currentPos.method_10084();
                    class_2680 blockBelowState = world.method_8320(blockBelowPos);
                    class_2680 blockAboveState = world.method_8320(blockAbovePos);
                    if (this.shouldPlaceSlabTop((class_1936)world, currentPos, blockBelowPos, blockAboveState, blockBelowState, currentBlockState = world.method_8320(currentPos))) {
                        if (world.method_8320(currentPos).method_27852(class_2246.field_10477)) {
                            if (world.method_8320(blockBelowPos).method_27852(class_2246.field_10219)) {
                                world.method_8652(blockBelowPos, class_2246.field_10566.method_9564(), 3);
                                world.method_8652(currentPos, (class_2680)((class_2680)ModBlocksRegistry.GRASS_SLAB.method_9564().method_11657((class_2769)class_2741.field_12512, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)CustomSlab.GENERATED, (Comparable)Boolean.valueOf(true)), 3);
                            } else {
                                world.method_8652(currentPos, (class_2680)ModSlabsMap.getSlabForBlock(world.method_8320(blockBelowPos).method_26204()).method_9564().method_11657((class_2769)CustomSlab.GENERATED, (Comparable)Boolean.valueOf(true)), 3);
                            }
                            world.method_8652(blockAbovePos, ModBlocksRegistry.SNOW_ON_TOP.method_9564(), 3);
                            continue;
                        }
                        blockBelowState = world.method_8320(blockBelowPos);
                        slabState = ModSlabsMap.getSlabForBlock(blockBelowState.method_26204()).method_9564();
                        if (SOIL_SLAB_BLOCKS.contains(slabState.method_26204())) {
                            world.method_8652(blockBelowPos, class_2246.field_10566.method_9564(), 3);
                        }
                        if (slabState.method_27852(ModBlocksRegistry.WARPED_NYLIUM_SLAB) || slabState.method_27852(ModBlocksRegistry.CRIMSON_NYLIUM_SLAB)) {
                            world.method_8652(blockBelowPos, class_2246.field_10515.method_9564(), 3);
                        }
                        slabState = this.updateWaterloggedState((class_1936)world, currentPos, slabState);
                        if (ModSlabsMap.ON_TOP_SLAB_BLOCKS_MAP.containsKey(currentBlockState.method_26204())) {
                            if (world.method_8320(blockAbovePos).method_27852(class_2246.field_10382)) {
                                world.method_8652(blockAbovePos, ModSlabsMap.ON_TOP_SLAB_BLOCKS_MAP.get(currentBlockState.method_26204()).method_9564(), 3);
                            } else if (!world.method_8320(currentPos).method_27852(class_2246.field_10376)) {
                                world.method_8652(blockAbovePos, ModSlabsMap.ON_TOP_SLAB_BLOCKS_MAP.get(currentBlockState.method_26204()).method_9564(), 3);
                            }
                        }
                        world.method_8652(currentPos, (class_2680)slabState.method_11657((class_2769)CustomSlab.GENERATED, (Comparable)Boolean.valueOf(true)), 3);
                        continue;
                    }
                    if (!this.shouldPlaceSlabOnUnderside((class_1936)world, currentPos, blockAbovePos, blockBelowPos, currentBlockState, blockBelowState)) continue;
                    slabState = ModSlabsMap.getSlabForBlock(currentBlockState.method_26204()).method_9564();
                    if (SOIL_SLAB_BLOCKS.contains(slabState.method_26204())) {
                        slabState = ModBlocksRegistry.DIRT_SLAB.method_9564();
                    }
                    slabState = (class_2680)slabState.method_11657((class_2769)class_2741.field_12485, (Comparable)class_2771.field_12679);
                    slabState = this.updateWaterloggedState((class_1936)world, currentPos, slabState);
                    world.method_8652(currentPos, (class_2680)slabState.method_11657((class_2769)CustomSlab.GENERATED, (Comparable)Boolean.valueOf(true)), 3);
                }
            }
        }
        return true;
    }

    private boolean shouldPlaceSlabTop(class_1936 world, class_2338 currentPos, class_2338 blockBelowPos, class_2680 blockAboveState, class_2680 blockBelow, class_2680 currentBlockState) {
        if (ModSlabsMap.getSlabForBlock(world.method_8320(blockBelowPos).method_26204()) == class_2246.field_10124 || world.method_8320(blockBelowPos).method_26204() instanceof class_2482 || world.method_8320(currentPos).method_27852(class_2246.field_27879)) {
            return false;
        }
        if (blockBelow.method_26225() && !(blockBelow.method_26204() instanceof class_2482) && this.bottomOfMountain(world, currentPos) && (!currentBlockState.method_26225() || currentBlockState.method_27852(class_2246.field_10477) || currentBlockState.method_45474()) && (blockAboveState.method_26215() || blockAboveState.method_27852(class_2246.field_10382))) {
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                class_2338 neighborPos = currentPos.method_10093(direction);
                class_2680 neighborState = world.method_8320(neighborPos);
                if (!neighborState.method_26225() || !VALID_BLOCKS_FOR_SLAB_PLACEMENT.contains(neighborState.method_26204()) || neighborState.method_26204() instanceof class_2482 || world.method_8320(neighborPos.method_10084()).method_26225() && world.method_8320(neighborPos.method_10084()).method_26204() != class_2246.field_10477 || world.method_8320(neighborPos).method_27852(class_2246.field_10477)) continue;
                return this.badNextToWaterSlab(world, currentPos, blockBelowPos, class_2350.field_11043) == false && this.badNextToWaterSlab(world, currentPos, blockBelowPos, class_2350.field_11039) == false && this.badNextToWaterSlab(world, currentPos, blockBelowPos, class_2350.field_11035) == false && this.badNextToWaterSlab(world, currentPos, blockBelowPos, class_2350.field_11034) == false && !world.method_8320(currentPos.method_10093(class_2350.field_11043)).method_27852(class_2246.field_10295) && !world.method_8320(currentPos.method_10093(class_2350.field_11039)).method_27852(class_2246.field_10295) && !world.method_8320(currentPos.method_10093(class_2350.field_11035)).method_27852(class_2246.field_10295) && !world.method_8320(currentPos.method_10093(class_2350.field_11034)).method_27852(class_2246.field_10295) && !world.method_8320(currentPos.method_10093(class_2350.field_11043)).method_27852(class_2246.field_10164) && !world.method_8320(currentPos.method_10093(class_2350.field_11039)).method_27852(class_2246.field_10164) && !world.method_8320(currentPos.method_10093(class_2350.field_11035)).method_27852(class_2246.field_10164) && !world.method_8320(currentPos.method_10093(class_2350.field_11034)).method_27852(class_2246.field_10164);
            }
        }
        return false;
    }

    private boolean shouldPlaceSlabOnUnderside(class_1936 world, class_2338 currentPos, class_2338 blockAbovePos, class_2338 blockBelowPos, class_2680 currentBlock, class_2680 blockBelow) {
        if (ModSlabsMap.getSlabForBlock(world.method_8320(blockAbovePos).method_26204()) == class_2246.field_10124 || world.method_8320(blockAbovePos).method_26204() instanceof class_2482) {
            return false;
        }
        if (VALID_BLOCKS_FOR_SLAB_PLACEMENT.contains(currentBlock.method_26204()) && (blockBelow.method_26215() || blockBelow.method_26204() == class_2246.field_10382) && currentBlock.method_26225()) {
            class_2680 neighborState;
            class_2338 neighborPos;
            for (class_2350 direction1 : class_2350.class_2353.field_11062) {
                neighborPos = currentPos.method_10093(direction1);
                neighborState = world.method_8320(neighborPos);
                if (!this.badNextToWaterSlab(world, currentPos, blockBelowPos, direction1).booleanValue() && !this.nextToGlowLichen(world, currentPos, direction1) && !neighborState.method_27852(class_2246.field_10164)) continue;
                return false;
            }
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                neighborPos = currentPos.method_10093(direction);
                neighborState = world.method_8320(neighborPos);
                if (!neighborState.method_26215() && neighborState.method_26204() != class_2246.field_10382) continue;
                return true;
            }
        }
        return false;
    }

    private class_2680 updateWaterloggedState(class_1936 world, class_2338 pos, class_2680 slabState) {
        if (slabState.method_28498((class_2769)class_2741.field_12508)) {
            if (world.method_8320(pos).method_27852(class_2246.field_10382) || world.method_8320(pos.method_10084()).method_27852(class_2246.field_10382)) {
                return (class_2680)slabState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true));
            }
            for (class_2350 direction1 : class_2350.class_2353.field_11062) {
                if (!world.method_8320(pos.method_10093(direction1)).method_27852(class_2246.field_10382)) continue;
                return (class_2680)slabState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true));
            }
        }
        return slabState;
    }

    private Boolean badNextToWaterSlab(class_1936 world, class_2338 currentPos, class_2338 blockBelowPos, class_2350 direction) {
        if (world.method_8320(currentPos.method_10093(direction)).method_27852(class_2246.field_10382) && (world.method_8320(blockBelowPos).method_27852(class_2246.field_10124) || world.method_8320(currentPos.method_10093(direction.method_10153())).method_26204() == class_2246.field_10124)) {
            return true;
        }
        return false;
    }

    private boolean bottomOfMountain(class_1936 world, class_2338 currentPos) {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            if (!world.method_8320(currentPos.method_10093(direction).method_10074()).method_26225() || !world.method_8320(currentPos.method_10093(direction.method_10153())).method_26225() || world.method_8320(currentPos.method_10093(direction).method_10074()).method_26204() instanceof class_2482 || world.method_8320(currentPos.method_10093(direction.method_10153())).method_26204() instanceof class_2482 || world.method_8320(currentPos.method_10093(direction.method_10153())).method_27852(class_2246.field_10477) || world.method_8320(currentPos.method_10093(direction).method_10074()).method_27852(class_2246.field_10477) || world.method_8320(currentPos.method_10093(direction.method_10153())).method_27852(ModBlocksRegistry.SNOW_ON_TOP) || world.method_8320(currentPos.method_10093(direction).method_10074()).method_27852(ModBlocksRegistry.SNOW_ON_TOP)) continue;
            return true;
        }
        return false;
    }

    private boolean nextToGlowLichen(class_1936 world, class_2338 currentPos, class_2350 direction) {
        return world.method_8320(currentPos.method_10093(direction)).method_27852(class_2246.field_28411);
    }

    static {
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_10219);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_10520);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_10402);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_10194);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_10566);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_28681);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_10225);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_10253);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_37576);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_10491);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_10460);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_28888);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_10340);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_10115);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_10508);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_10474);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_27165);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_9979);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_10344);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_10102);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_10255);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_10534);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_10415);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_10123);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_10328);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_10184);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_10590);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_10143);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_10611);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_10114);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_22090);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_10515);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_22113);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_22120);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_22091);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_23869);
        VALID_BLOCKS_FOR_SLAB_PLACEMENT.add(class_2246.field_10471);
        SOIL_SLAB_BLOCKS = Set.of(ModBlocksRegistry.GRASS_SLAB, ModBlocksRegistry.PODZOL_SLAB, ModBlocksRegistry.MYCELIUM_SLAB, ModBlocksRegistry.PATH_SLAB);
    }
}

