/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.client.screens;

import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.Owo;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import io.wispforest.owo.util.pond.OwoScreenHandlerExtension;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ScreenInternals {
    public static final ResourceLocation SYNC_PROPERTIES = ResourceLocation.fromNamespaceAndPath((String)"owo", (String)"sync_screen_handler_properties");

    public static void init() {
        StreamCodec localPacketCodec = CodecUtils.toPacketCodec(LocalPacket.ENDEC);
        PayloadTypeRegistry.playS2C().register(LocalPacket.ID, localPacketCodec);
        PayloadTypeRegistry.playC2S().register(LocalPacket.ID, localPacketCodec);
        PayloadTypeRegistry.playS2C().register(SyncPropertiesPacket.ID, CodecUtils.toPacketCodec(SyncPropertiesPacket.ENDEC));
        ServerPlayNetworking.registerGlobalReceiver(LocalPacket.ID, (payload, context) -> {
            AbstractContainerMenu screenHandler = context.player().containerMenu;
            if (screenHandler == null) {
                Owo.LOGGER.error("Received local packet for null ScreenHandler");
                return;
            }
            ((OwoScreenHandlerExtension)screenHandler).owo$handlePacket((LocalPacket)payload, false);
        });
    }

    public record LocalPacket(int packetId, FriendlyByteBuf payload) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<LocalPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"owo", (String)"local_packet"));
        public static final Endec<LocalPacket> ENDEC = StructEndecBuilder.of((StructField)Endec.VAR_INT.fieldOf("packetId", LocalPacket::packetId), (StructField)MinecraftEndecs.PACKET_BYTE_BUF.fieldOf("payload", LocalPacket::payload), LocalPacket::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }
    }

    public record SyncPropertiesPacket(FriendlyByteBuf payload) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SyncPropertiesPacket> ID = new CustomPacketPayload.Type(SYNC_PROPERTIES);
        public static final Endec<SyncPropertiesPacket> ENDEC = StructEndecBuilder.of((StructField)MinecraftEndecs.PACKET_BYTE_BUF.fieldOf("payload", SyncPropertiesPacket::payload), SyncPropertiesPacket::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Client {
        public static void init() {
            ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
                if (screen instanceof MenuAccess) {
                    MenuAccess handled = (MenuAccess)screen;
                    ((OwoScreenHandlerExtension)handled.getMenu()).owo$attachToPlayer((Player)client.player);
                }
            });
            ClientPlayNetworking.registerGlobalReceiver(LocalPacket.ID, (payload, context) -> {
                AbstractContainerMenu screenHandler = context.player().containerMenu;
                if (screenHandler == null) {
                    Owo.LOGGER.error("Received local packet for null ScreenHandler");
                    return;
                }
                ((OwoScreenHandlerExtension)screenHandler).owo$handlePacket((LocalPacket)payload, true);
            });
            ClientPlayNetworking.registerGlobalReceiver(SyncPropertiesPacket.ID, (payload, context) -> {
                AbstractContainerMenu screenHandler = context.player().containerMenu;
                if (screenHandler == null) {
                    Owo.LOGGER.error("Received sync properties packet for null ScreenHandler");
                    return;
                }
                ((OwoScreenHandlerExtension)screenHandler).owo$readPropertySync((SyncPropertiesPacket)payload);
            });
        }
    }
}

