/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.particles.systems;

import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.ReflectiveEndecBuilder;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.network.NetworkException;
import io.wispforest.owo.network.OwoHandshake;
import io.wispforest.owo.particles.systems.ParticleSystem;
import io.wispforest.owo.particles.systems.ParticleSystemExecutor;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import io.wispforest.owo.util.OwoFreezer;
import io.wispforest.owo.util.ReflectionUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLLoader;
import org.jetbrains.annotations.ApiStatus;

public class ParticleSystemController {
    @ApiStatus.Internal
    public static final Map<ResourceLocation, ParticleSystemController> REGISTERED_CONTROLLERS = new HashMap<ResourceLocation, ParticleSystemController>();
    @ApiStatus.Internal
    public final Int2ObjectMap<ParticleSystem<?>> systemsByIndex = new Int2ObjectOpenHashMap();
    public final ResourceLocation channelId;
    private final CustomPacketPayload.Type<ParticleSystemPayload> payloadId;
    private int maxIndex = 0;
    private final String ownerClassName;
    private final ReflectiveEndecBuilder builder;

    public ParticleSystemController(ResourceLocation channelId) {
        OwoFreezer.checkRegister("Particle system controllers");
        this.builder = MinecraftEndecs.addDefaults(new ReflectiveEndecBuilder());
        if (REGISTERED_CONTROLLERS.containsKey(channelId)) {
            throw new IllegalStateException("Controller with id '" + String.valueOf(channelId) + "' was already registered from class '" + ParticleSystemController.REGISTERED_CONTROLLERS.get((Object)channelId).ownerClassName + "'");
        }
        this.channelId = channelId;
        this.payloadId = new CustomPacketPayload.Type(channelId);
        this.ownerClassName = ReflectionUtils.getCallingClassName(2);
        Endec instanceEndec = Endec.dispatched(index -> {
            ParticleSystem system = (ParticleSystem)this.systemsByIndex.get(index);
            return system.endec.xmap(x -> new ParticleSystemInstance<Object>(system, x), x -> x.data);
        }, instance -> instance.system.index, (Endec)Endec.VAR_INT);
        StructEndec endec = StructEndecBuilder.of((StructField)MinecraftEndecs.VEC3D.fieldOf("pos", ParticleSystemPayload::pos), (StructField)instanceEndec.fieldOf("instance", ParticleSystemPayload::instance), (pos, instance) -> new ParticleSystemPayload(this.payloadId, (Vec3)pos, (ParticleSystemInstance<?>)instance));
        PayloadTypeRegistry.playS2C().register(this.payloadId, CodecUtils.toPacketCodec(endec));
        OwoHandshake.enable();
        OwoHandshake.requireHandshake();
        if (FMLLoader.getDist() == Dist.CLIENT) {
            ClientPlayNetworking.registerGlobalReceiver(this.payloadId, new Client()::handler);
        }
        REGISTERED_CONTROLLERS.put(channelId, this);
    }

    public ReflectiveEndecBuilder endecBuilder() {
        return this.builder;
    }

    public <T> ParticleSystem<T> register(Class<T> dataClass, Endec<T> endec, ParticleSystemExecutor<T> executor) {
        int index = this.maxIndex++;
        ParticleSystem<T> system = new ParticleSystem<T>(this, dataClass, index, endec, executor);
        this.systemsByIndex.put(index, system);
        return system;
    }

    public <T> ParticleSystem<T> register(Class<T> dataClass, ParticleSystemExecutor<T> executor) {
        return this.register(dataClass, this.builder.get(dataClass), executor);
    }

    public <T> ParticleSystem<T> registerDeferred(Class<T> dataClass, Endec<T> endec) {
        int index = this.maxIndex++;
        ParticleSystem<T> system = new ParticleSystem<T>(this, dataClass, index, endec, null);
        this.systemsByIndex.put(index, system);
        return system;
    }

    public <T> ParticleSystem<T> registerDeferred(Class<T> dataClass) {
        return this.registerDeferred(dataClass, this.builder.get(dataClass));
    }

    <T> void sendPacket(ParticleSystem<T> particleSystem, ServerLevel world, Vec3 pos, T data) {
        ParticleSystemPayload payload = new ParticleSystemPayload(this.payloadId, pos, new ParticleSystemInstance<T>(particleSystem, data));
        for (ServerPlayer player : PlayerLookup.tracking((ServerLevel)world, (BlockPos)BlockPos.containing((Position)pos))) {
            ServerPlayNetworking.send((ServerPlayer)player, (CustomPacketPayload)payload);
        }
    }

    private void verify() {
        if (FMLLoader.getDist() == Dist.CLIENT) {
            for (ParticleSystem system : this.systemsByIndex.values()) {
                if (system.handler != null) continue;
                throw new NetworkException("Some particle systems of " + String.valueOf(this.channelId) + " don't have handlers registered");
            }
        }
    }

    static {
        OwoFreezer.registerFreezeCallback(() -> {
            for (ParticleSystemController controller : REGISTERED_CONTROLLERS.values()) {
                controller.verify();
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class Client {
        private Client() {
        }

        private void handler(ParticleSystemPayload payload, ClientPlayNetworking.Context context) {
            payload.instance.execute((Level)context.client().level, payload.pos);
        }
    }

    private record ParticleSystemPayload(CustomPacketPayload.Type<ParticleSystemPayload> id, Vec3 pos, ParticleSystemInstance<?> instance) implements CustomPacketPayload
    {
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return this.id;
        }
    }

    private record ParticleSystemInstance<T>(ParticleSystem<T> system, T data) {
        public void execute(Level world, Vec3 pos) {
            this.system.handler.executeParticleSystem(world, pos, this.data);
        }
    }
}

