/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.registration.reflect;

import io.wispforest.owo.registration.reflect.AutoRegistryContainer;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public interface BlockRegistryContainer
extends AutoRegistryContainer<Block> {
    @Override
    default public Registry<Block> getRegistry() {
        return BuiltInRegistries.BLOCK;
    }

    @Override
    default public Class<Block> getTargetFieldType() {
        return Block.class;
    }

    @Override
    default public void postProcessField(String namespace, Block value, String identifier, Field field) {
        if (field.isAnnotationPresent(NoBlockItem.class)) {
            return;
        }
        Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)namespace, (String)identifier), (Object)this.createBlockItem(value, identifier));
    }

    default public BlockItem createBlockItem(Block block, String identifier) {
        return new BlockItem(block, new Item.Properties());
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface NoBlockItem {
    }
}

