/*
 * Decompiled with CFR 0.152.
 */
package me.drex.antixray.common.config;

import com.moandjiezana.toml.Toml;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import me.drex.antixray.common.AntiXray;
import me.drex.antixray.common.config.Config;
import me.drex.antixray.common.util.EngineMode;
import me.drex.antixray.common.util.controller.ChunkPacketBlockController;
import me.drex.antixray.common.util.controller.DisabledChunkPacketBlockController;
import me.drex.antixray.common.util.controller.HideChunkPacketBlockController;
import me.drex.antixray.common.util.controller.ObfuscateChunkPacketBlockController;
import me.drex.antixray.common.util.controller.ObfuscateLayerChunkPacketBlockController;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class WorldConfig {
    public boolean enabled = false;
    public EngineMode engineMode = EngineMode.HIDE;
    public int maxBlockHeight = 64;
    public int updateRadius = 2;
    public boolean lavaObscures = false;
    public Set<Block> hiddenBlocks = new HashSet<Block>();
    public Set<Block> replacementBlocks = new HashSet<Block>();

    public WorldConfig(ResourceLocation location) {
        Toml defaultToml = Config.toml;
        this.loadValues(defaultToml);
        Toml worldToml = defaultToml.getTable(location.getPath());
        if (worldToml != null) {
            this.loadValues(worldToml);
        } else {
            this.loadValues(defaultToml.getTable("'" + String.valueOf(location) + "'"));
            this.loadValues(defaultToml.getTable("\"" + String.valueOf(location) + "\""));
        }
    }

    private void loadValues(Toml toml) {
        EngineMode mode;
        if (toml == null) {
            return;
        }
        if (toml.contains("enabled")) {
            this.enabled = toml.getBoolean("enabled");
        }
        if (toml.contains("engineMode") && (mode = EngineMode.getById(Math.toIntExact(toml.getLong("engineMode")))) != null) {
            this.engineMode = mode;
        }
        if (toml.contains("maxBlockHeight")) {
            this.maxBlockHeight = Math.toIntExact(toml.getLong("maxBlockHeight")) >> 4 << 4;
        }
        if (toml.contains("updateRadius")) {
            this.updateRadius = Math.toIntExact(toml.getLong("updateRadius"));
        }
        if (toml.contains("lavaObscures")) {
            this.lavaObscures = toml.getBoolean("lavaObscures");
        }
        if (toml.contains("hiddenBlocks")) {
            this.hiddenBlocks = this.parseBlocks(toml.getList("hiddenBlocks"));
        }
        if (toml.contains("replacementBlocks")) {
            this.replacementBlocks = this.parseBlocks(toml.getList("replacementBlocks"));
        }
    }

    private Set<Block> parseBlocks(List<String> blocks) {
        HashSet<Block> result = new HashSet<Block>();
        for (String blockId : blocks) {
            try {
                StringReader stringReader = new StringReader(blockId);
                boolean isTag = false;
                if (stringReader.canRead() && stringReader.peek() == '#') {
                    isTag = true;
                    stringReader.skip();
                }
                ResourceLocation location = ResourceLocation.read((StringReader)stringReader);
                if (isTag) {
                    TagKey tagKey = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)location);
                    Optional optional = BuiltInRegistries.BLOCK.getTag(tagKey);
                    if (optional.isPresent()) {
                        for (Holder holder : (HolderSet.Named)optional.get()) {
                            result.add((Block)holder.value());
                        }
                        continue;
                    }
                    AntiXray.LOGGER.warn("Unknown block tag id: \"{}\"", (Object)blockId);
                    continue;
                }
                Optional optional = BuiltInRegistries.BLOCK.getOptional(location);
                optional.ifPresentOrElse(result::add, () -> AntiXray.LOGGER.warn("Unknown block id: \"{}\"", (Object)blockId));
            }
            catch (CommandSyntaxException exception) {
                AntiXray.LOGGER.warn("Failed to parse block: \"{}\"", (Object)blockId, (Object)exception);
            }
        }
        return result;
    }

    public ChunkPacketBlockController createChunkPacketBlockController(Level level) {
        if (!this.enabled) {
            return DisabledChunkPacketBlockController.NO_OPERATION_INSTANCE;
        }
        return switch (this.engineMode) {
            default -> throw new MatchException(null, null);
            case EngineMode.HIDE -> new HideChunkPacketBlockController(level, this.hiddenBlocks, this.maxBlockHeight, this.updateRadius, this.lavaObscures);
            case EngineMode.OBFUSCATE -> new ObfuscateChunkPacketBlockController(level, this.replacementBlocks, this.hiddenBlocks, this.maxBlockHeight, this.updateRadius, this.lavaObscures);
            case EngineMode.OBFUSCATE_LAYER -> new ObfuscateLayerChunkPacketBlockController(level, this.replacementBlocks, this.hiddenBlocks, this.maxBlockHeight, this.updateRadius, this.lavaObscures);
        };
    }
}

