/*
 * Decompiled with CFR 0.152.
 */
package me.drex.antixray.common.mixin;

import com.google.common.collect.Queues;
import io.netty.channel.Channel;
import java.util.Queue;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import me.drex.antixray.common.util.Util;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.protocol.Packet;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Connection.class})
public abstract class ConnectionMixin {
    @Unique
    private final Queue<BooleanSupplier> antiXray$isActionReady = Queues.newConcurrentLinkedQueue();
    @Shadow
    private Channel channel;
    @Shadow
    @Final
    private Queue<Consumer<Connection>> pendingActions;

    @Shadow
    protected abstract void sendPacket(Packet<?> var1, PacketSendListener var2, boolean var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    private void flushQueue() {
        assert (this.pendingActions.size() == this.antiXray$isActionReady.size());
        if (this.channel != null && this.channel.isOpen()) {
            Queue<Consumer<Connection>> queue = this.pendingActions;
            synchronized (queue) {
                while (!this.antiXray$isActionReady.isEmpty() && this.antiXray$isActionReady.peek().getAsBoolean()) {
                    this.pendingActions.poll().accept((Connection)this);
                    this.antiXray$isActionReady.poll();
                }
            }
        }
    }

    @Redirect(method={"send(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketSendListener;Z)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/Connection;sendPacket(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketSendListener;Z)V"))
    public void redirectSendPacket(Connection instance, Packet<?> packet, PacketSendListener listener, boolean flush) {
        if (this.antiXray$isActionReady.isEmpty() && Util.isReady(packet)) {
            this.sendPacket(packet, listener, flush);
        } else {
            this.pendingActions.add(connection -> this.sendPacket(packet, listener, flush));
            this.antiXray$isActionReady.add(() -> Util.isReady(packet));
        }
    }

    @Inject(method={"send(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketSendListener;Z)V"}, at={@At(value="INVOKE", target="Ljava/util/Queue;add(Ljava/lang/Object;)Z")})
    public void addToActionReadyQueue(Packet<?> packet, PacketSendListener listener, boolean flush, CallbackInfo ci) {
        this.antiXray$isActionReady.add(() -> Util.isReady(packet));
    }

    @Inject(method={"flushChannel()V", "runOnceConnected(Ljava/util/function/Consumer;)V"}, at={@At(value="INVOKE", target="Ljava/util/Queue;add(Ljava/lang/Object;)Z")})
    public void addToActionReadyQueue(CallbackInfo ci) {
        this.antiXray$isActionReady.add(() -> true);
    }
}

