/*
 * Decompiled with CFR 0.152.
 */
package me.drex.antixray.common.mixin;

import me.drex.antixray.common.config.WorldConfig;
import me.drex.antixray.common.interfaces.ILevel;
import me.drex.antixray.common.util.controller.ChunkPacketBlockController;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Level.class})
public abstract class LevelMixin
implements ILevel,
LevelAccessor {
    @Unique
    public ChunkPacketBlockController chunkPacketBlockController;
    @Shadow
    @Final
    private ResourceKey<Level> dimension;

    @Shadow
    public abstract BlockState getBlockState(BlockPos var1);

    @Override
    public void initValues() {
        LevelMixin levelMixin = this;
        if (!(levelMixin instanceof ServerLevel)) {
            throw new IllegalStateException();
        }
        ServerLevel serverLevel = (ServerLevel)levelMixin;
        WorldConfig worldConfig = new WorldConfig(this.dimension.location());
        this.chunkPacketBlockController = worldConfig.createChunkPacketBlockController((Level)serverLevel);
    }

    @Override
    public ChunkPacketBlockController getChunkPacketBlockController() {
        return this.chunkPacketBlockController;
    }

    @Inject(method={"setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;II)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/LevelChunk;setBlockState(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)Lnet/minecraft/world/level/block/state/BlockState;")}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void onBlockChange(BlockPos blockPos, BlockState blockState, int flags, int maxUpdateDepth, CallbackInfoReturnable<Boolean> cir, LevelChunk levelChunk) {
        LevelMixin levelMixin = this;
        if (levelMixin instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelMixin;
            BlockState oldState = levelChunk.getBlockState(blockPos);
            this.chunkPacketBlockController.onBlockChange(serverLevel, blockPos, blockState, oldState, flags, maxUpdateDepth);
        }
    }
}

