/*
 * Decompiled with CFR 0.152.
 */
package me.drex.antixray.common.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import me.drex.antixray.common.util.Arguments;
import me.drex.antixray.common.util.ChunkPacketInfo;
import net.minecraft.core.IdMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.BitStorage;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PalettedContainer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PalettedContainer.class})
public abstract class PalettedContainerMixin<T> {
    @Unique
    private T[] antiXray$presetValues;
    @Shadow
    private volatile PalettedContainer.Data<T> data;
    @Shadow
    @Final
    private PalettedContainer.Strategy strategy;
    @Shadow
    @Final
    private IdMap<T> registry;

    @Shadow
    public abstract int onResize(int var1, T var2);

    @Shadow
    protected abstract PalettedContainer.Data<T> createOrReuseData(PalettedContainer.Data<T> var1, int var2);

    @Inject(method={"<init>(Lnet/minecraft/core/IdMap;Lnet/minecraft/world/level/chunk/PalettedContainer$Strategy;Lnet/minecraft/world/level/chunk/PalettedContainer$Configuration;Lnet/minecraft/util/BitStorage;Ljava/util/List;)V"}, at={@At(value="TAIL")})
    private void addPresetValuesWithEntries(IdMap<T> idList, PalettedContainer.Strategy strategy, PalettedContainer.Configuration<T> configuration, BitStorage storage, List<T> paletteEntries, CallbackInfo ci) {
        this.antiXray$presetValues = Arguments.PRESET_VALUES.get();
        if (this.antiXray$presetValues != null && (configuration.factory() == PalettedContainer.Strategy.SINGLE_VALUE_PALETTE_FACTORY ? this.data.palette().valueFor(0) != Blocks.AIR.defaultBlockState() : configuration.factory() != PalettedContainer.Strategy.GLOBAL_PALETTE_FACTORY)) {
            int maxSize = 1 << configuration.bits();
            for (T presetValue : this.antiXray$presetValues) {
                if (this.data.palette().getSize() >= maxSize) {
                    HashSet<T> allValues = new HashSet<T>(paletteEntries);
                    allValues.addAll(Arrays.asList(this.antiXray$presetValues));
                    int newBits = Mth.ceillog2((int)allValues.size());
                    if (newBits <= configuration.bits()) break;
                    this.onResize(newBits, null);
                    break;
                }
                this.data.palette().idFor(presetValue);
            }
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/core/IdMap;Ljava/lang/Object;Lnet/minecraft/world/level/chunk/PalettedContainer$Strategy;)V"}, at={@At(value="TAIL")})
    public void addPresetValuesInit(IdMap<T> idMap, Object object, PalettedContainer.Strategy strategy, CallbackInfo ci) {
        this.antiXray$presetValues = Arguments.PRESET_VALUES.get();
    }

    @Inject(method={"<init>(Lnet/minecraft/core/IdMap;Lnet/minecraft/world/level/chunk/PalettedContainer$Strategy;Lnet/minecraft/world/level/chunk/PalettedContainer$Data;)V"}, at={@At(value="TAIL")})
    public void addPresetValuesInit(IdMap<T> idMap, PalettedContainer.Strategy strategy, PalettedContainer.Data<T> data, CallbackInfo ci) {
        this.antiXray$presetValues = Arguments.PRESET_VALUES.get();
    }

    @Redirect(method={"onResize(ILjava/lang/Object;)I"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/PalettedContainer;createOrReuseData(Lnet/minecraft/world/level/chunk/PalettedContainer$Data;I)Lnet/minecraft/world/level/chunk/PalettedContainer$Data;"))
    private PalettedContainer.Data<T> addPresetValues(PalettedContainer<T> container, PalettedContainer.Data<T> data, int bits, int i, T object) {
        if (this.antiXray$presetValues != null && object != null && data.configuration().factory() == PalettedContainer.Strategy.SINGLE_VALUE_PALETTE_FACTORY) {
            int duplicates = 0;
            List<T> presetValues = Arrays.asList(this.antiXray$presetValues);
            duplicates += presetValues.contains(object) ? 1 : 0;
            bits = Mth.ceillog2((int)((1 << this.strategy.calculateBitsForSerialization(this.registry, 1 << bits)) + presetValues.size() - (duplicates += presetValues.contains(data.palette().valueFor(0)) ? 1 : 0)));
        }
        return this.createOrReuseData(data, bits);
    }

    @Redirect(method={"onResize(ILjava/lang/Object;)I"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/Palette;idFor(Ljava/lang/Object;)I"))
    private int addPresetValues(Palette<T> palette, T object) {
        this.antiXray$addPresetValues();
        return object == null ? -1 : palette.idFor(object);
    }

    @Inject(method={"write(Lnet/minecraft/network/FriendlyByteBuf;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/PalettedContainer$Data;write(Lnet/minecraft/network/FriendlyByteBuf;)V", shift=At.Shift.AFTER)})
    public void setPresetValues(FriendlyByteBuf friendlyByteBuf, CallbackInfo ci) {
        ChunkPacketInfo<BlockState> chunkPacketInfo = Arguments.PACKET_INFO.get();
        Integer chunkSectionIndex = Arguments.CHUNK_SECTION_INDEX.get();
        if (chunkPacketInfo != null) {
            chunkPacketInfo.setPresetValues(chunkSectionIndex, (BlockState[])((BlockState[])this.antiXray$presetValues));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapOperation(method={"copy()Lnet/minecraft/world/level/chunk/PalettedContainer;"}, at={@At(value="NEW", target="(Lnet/minecraft/core/IdMap;Lnet/minecraft/world/level/chunk/PalettedContainer$Strategy;Lnet/minecraft/world/level/chunk/PalettedContainer$Data;)Lnet/minecraft/world/level/chunk/PalettedContainer;")})
    private PalettedContainer<T> addPresetValuesCopy(IdMap<T> idMap, PalettedContainer.Strategy strategy, PalettedContainer.Data<T> data, Operation<PalettedContainer<T>> original) {
        Object[] previous = Arguments.PRESET_VALUES.get();
        Arguments.PRESET_VALUES.set(this.antiXray$presetValues);
        try {
            PalettedContainer palettedContainer = (PalettedContainer)original.call(new Object[]{idMap, strategy, data});
            return palettedContainer;
        }
        finally {
            Arguments.PRESET_VALUES.set(previous);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapOperation(method={"recreate()Lnet/minecraft/world/level/chunk/PalettedContainer;"}, at={@At(value="NEW", target="(Lnet/minecraft/core/IdMap;Ljava/lang/Object;Lnet/minecraft/world/level/chunk/PalettedContainer$Strategy;)Lnet/minecraft/world/level/chunk/PalettedContainer;")})
    private PalettedContainer<T> addPresetValuesRecreate(IdMap<T> idMap, Object object, PalettedContainer.Strategy strategy, Operation<PalettedContainer<T>> original) {
        Object[] previous = Arguments.PRESET_VALUES.get();
        Arguments.PRESET_VALUES.set(this.antiXray$presetValues);
        try {
            PalettedContainer palettedContainer = (PalettedContainer)original.call(new Object[]{idMap, object, strategy});
            return palettedContainer;
        }
        finally {
            Arguments.PRESET_VALUES.set(previous);
        }
    }

    @Unique
    private void antiXray$addPresetValues() {
        if (this.antiXray$presetValues != null && this.data.configuration().factory() != PalettedContainer.Strategy.GLOBAL_PALETTE_FACTORY) {
            for (T presetValue : this.antiXray$presetValues) {
                this.data.palette().idFor(presetValue);
            }
        }
    }
}

