/*
 * Decompiled with CFR 0.152.
 */
package me.drex.antixray.common.util.controller;

import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.IntSupplier;
import me.drex.antixray.common.AntiXray;
import me.drex.antixray.common.util.BitStorageReader;
import me.drex.antixray.common.util.BitStorageWriter;
import me.drex.antixray.common.util.ChunkPacketInfo;
import me.drex.antixray.common.util.ChunkPacketInfoAntiXray;
import me.drex.antixray.common.util.controller.ChunkPacketBlockController;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.GlobalPalette;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.MissingPaletteEntryException;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.status.ChunkStatus;

public abstract class ChunkPacketBlockControllerAntiXray
implements ChunkPacketBlockController {
    protected static final Palette<BlockState> GLOBAL_BLOCKSTATE_PALETTE = new GlobalPalette((IdMap)Block.BLOCK_STATE_REGISTRY);
    private static final LevelChunkSection EMPTY_SECTION = null;
    private static final ThreadLocal<boolean[]> SOLID = ThreadLocal.withInitial(() -> new boolean[Block.BLOCK_STATE_REGISTRY.size()]);
    private static final ThreadLocal<boolean[]> OBFUSCATE = ThreadLocal.withInitial(() -> new boolean[Block.BLOCK_STATE_REGISTRY.size()]);
    private static final ThreadLocal<boolean[][]> CURRENT = ThreadLocal.withInitial(() -> new boolean[16][16]);
    private static final ThreadLocal<boolean[][]> NEXT = ThreadLocal.withInitial(() -> new boolean[16][16]);
    private static final ThreadLocal<boolean[][]> NEXT_NEXT = ThreadLocal.withInitial(() -> new boolean[16][16]);
    protected final int maxBlockHeight;
    private final int maxBlockHeightUpdatePosition;
    private final int updateRadius;
    private final Object2BooleanOpenHashMap<BlockState> solidGlobal = new Object2BooleanOpenHashMap(Block.BLOCK_STATE_REGISTRY.size());
    private final Object2BooleanOpenHashMap<BlockState> obfuscateGlobal = new Object2BooleanOpenHashMap(Block.BLOCK_STATE_REGISTRY.size());
    private final LevelChunkSection[] emptyNearbyChunkSections = new LevelChunkSection[]{EMPTY_SECTION, EMPTY_SECTION, EMPTY_SECTION, EMPTY_SECTION};
    private final ThreadLocal<int[]> presetBlockStateBits = ThreadLocal.withInitial(() -> new int[this.getPresetBlockStatesLength()]);

    protected ChunkPacketBlockControllerAntiXray(Level level, Set<Block> toObfuscate, int maxBlockHeight, int updateRadius, boolean lavaObscures) {
        this.maxBlockHeight = maxBlockHeight;
        this.updateRadius = updateRadius;
        for (Block block : toObfuscate) {
            if (block.defaultBlockState().isAir()) continue;
            for (BlockState blockState2 : block.getStateDefinition().getPossibleStates()) {
                this.obfuscateGlobal.put((Object)blockState2, true);
            }
        }
        EmptyLevelChunk emptyChunk = new EmptyLevelChunk(level, new ChunkPos(0, 0), (Holder)level.registryAccess().registryOrThrow(Registries.BIOME).getHolderOrThrow(Biomes.PLAINS));
        Block.BLOCK_STATE_REGISTRY.iterator().forEachRemaining(blockState -> this.solidGlobal.put(blockState, ChunkPacketBlockControllerAntiXray.isSolid(emptyChunk, blockState, lavaObscures)));
        this.maxBlockHeightUpdatePosition = maxBlockHeight + updateRadius - 1;
    }

    public ChunkPacketInfoAntiXray getChunkPacketInfo(ClientboundLevelChunkWithLightPacket chunkPacket, LevelChunk chunk) {
        return new ChunkPacketInfoAntiXray(chunkPacket, chunk, this);
    }

    @Override
    public void onBlockChange(ServerLevel level, BlockPos blockPos, BlockState newBlockState, BlockState oldBlockState, int flags, int maxUpdateDepth) {
        if (oldBlockState != null && this.solidGlobal.getOrDefault((Object)oldBlockState, false) && !this.solidGlobal.getOrDefault((Object)newBlockState, false) && blockPos.getY() <= this.maxBlockHeightUpdatePosition) {
            this.updateNearbyBlocks(level, blockPos);
        }
    }

    @Override
    public void modifyBlocks(ClientboundLevelChunkWithLightPacket chunkPacket, ChunkPacketInfo<BlockState> chunkPacketInfo) {
        ServerLevel serverLevel;
        if (!(chunkPacketInfo instanceof ChunkPacketInfoAntiXray)) {
            chunkPacket.antixray$setReady(true);
            return;
        }
        ChunkPacketInfoAntiXray antiXrayInfo = (ChunkPacketInfoAntiXray)chunkPacketInfo;
        Level level = chunkPacketInfo.getChunk().getLevel();
        if (level instanceof ServerLevel && !(serverLevel = (ServerLevel)level).getServer().isSameThread()) {
            serverLevel.getServer().execute(() -> this.modifyBlocks(chunkPacket, chunkPacketInfo));
            return;
        }
        LevelChunk chunk = chunkPacketInfo.getChunk();
        int x = chunk.getPos().x;
        int z = chunk.getPos().z;
        ServerChunkCache chunkCache = ((ServerLevel)chunk.getLevel()).getChunkSource();
        antiXrayInfo.setNearbyChunks(this.getChunkAccess(chunkCache, x - 1, z), this.getChunkAccess(chunkCache, x + 1, z), this.getChunkAccess(chunkCache, x, z - 1), this.getChunkAccess(chunkCache, x, z + 1));
        Util.backgroundExecutor().execute((Runnable)((Object)chunkPacketInfo));
    }

    private ChunkAccess getChunkAccess(ServerChunkCache chunkCache, int chunkX, int chunkZ) {
        ChunkHolder chunkHolder = chunkCache.getVisibleChunkIfPresent(ChunkPos.asLong((int)chunkX, (int)chunkZ));
        if (chunkHolder != null) {
            ChunkAccess chunkAccess = chunkHolder.getLatestChunk();
            if (chunkAccess != null) {
                return chunkAccess;
            }
            AntiXray.LOGGER.warn("Chunk at [{}, {}] not available, falling back to getChunk", (Object)chunkX, (Object)chunkZ);
        } else {
            AntiXray.LOGGER.warn("Chunk at [{}, {}] not visible, falling back to getChunk", (Object)chunkX, (Object)chunkZ);
        }
        return chunkCache.getChunk(chunkX, chunkZ, ChunkStatus.LIGHT, true);
    }

    @Override
    public void onPlayerLeftClickBlock(ServerPlayerGameMode serverPlayerGameMode, BlockPos blockPos, ServerboundPlayerActionPacket.Action action, Direction direction, int worldHeight) {
        if (blockPos.getY() <= this.maxBlockHeightUpdatePosition) {
            this.updateNearbyBlocks(serverPlayerGameMode.level, blockPos);
        }
    }

    private void updateNearbyBlocks(ServerLevel level, BlockPos blockPos) {
        if (this.updateRadius >= 2) {
            BlockPos temp = blockPos.west();
            this.updateBlock(level, temp);
            this.updateBlock(level, temp.west());
            this.updateBlock(level, temp.below());
            this.updateBlock(level, temp.above());
            this.updateBlock(level, temp.north());
            this.updateBlock(level, temp.south());
            temp = blockPos.east();
            this.updateBlock(level, temp);
            this.updateBlock(level, temp.east());
            this.updateBlock(level, temp.below());
            this.updateBlock(level, temp.above());
            this.updateBlock(level, temp.north());
            this.updateBlock(level, temp.south());
            temp = blockPos.below();
            this.updateBlock(level, temp);
            this.updateBlock(level, temp.below());
            this.updateBlock(level, temp.north());
            this.updateBlock(level, temp.south());
            temp = blockPos.above();
            this.updateBlock(level, temp);
            this.updateBlock(level, temp.above());
            this.updateBlock(level, temp.north());
            this.updateBlock(level, temp.south());
            temp = blockPos.north();
            this.updateBlock(level, temp);
            this.updateBlock(level, temp.north());
            temp = blockPos.south();
            this.updateBlock(level, temp);
            this.updateBlock(level, temp.south());
        } else if (this.updateRadius == 1) {
            this.updateBlock(level, blockPos.west());
            this.updateBlock(level, blockPos.east());
            this.updateBlock(level, blockPos.below());
            this.updateBlock(level, blockPos.above());
            this.updateBlock(level, blockPos.north());
            this.updateBlock(level, blockPos.south());
        }
    }

    protected abstract int getPresetBlockStatesLength();

    protected abstract int[] getPresetBlockStateBits(Level var1, int var2);

    private void updateBlock(ServerLevel level, BlockPos pos) {
        LevelChunk chunk = level.getChunkSource().getChunk(pos.getX() >> 4, pos.getZ() >> 4, false);
        if (chunk != null && this.obfuscateGlobal.getOrDefault((Object)chunk.getBlockState(pos), false)) {
            level.getChunkSource().blockChanged(pos);
        }
    }

    public void obfuscate(ChunkPacketInfoAntiXray chunkPacketInfoAntiXray) {
        int[] presetBlockStateBits = this.presetBlockStateBits.get();
        boolean[] solid = SOLID.get();
        boolean[] obfuscate = OBFUSCATE.get();
        boolean[][] current = CURRENT.get();
        boolean[][] next = NEXT.get();
        boolean[][] nextNext = NEXT_NEXT.get();
        BitStorageReader bitStorageReader = new BitStorageReader();
        BitStorageWriter bitStorageWriter = new BitStorageWriter();
        LevelChunkSection[] nearbyChunkSections = new LevelChunkSection[4];
        LevelChunk chunk = chunkPacketInfoAntiXray.getChunk();
        Level level = chunk.getLevel();
        int maxChunkSectionIndex = Math.min((this.maxBlockHeight >> 4) - chunk.getMinSection(), chunk.getSectionsCount() - 1);
        bitStorageReader.setBuffer(chunkPacketInfoAntiXray.getBuffer());
        bitStorageWriter.setBuffer(chunkPacketInfoAntiXray.getBuffer());
        int numberOfBlocks = presetBlockStateBits.length;
        for (int chunkSectionIndex = 0; chunkSectionIndex <= maxChunkSectionIndex; ++chunkSectionIndex) {
            int x;
            int z;
            if (!chunkPacketInfoAntiXray.isWritten(chunkSectionIndex) || chunkPacketInfoAntiXray.getPresetValues(chunkSectionIndex) == null) continue;
            if (chunkPacketInfoAntiXray.getPalette(chunkSectionIndex) instanceof GlobalPalette) {
                presetBlockStateBits = this.getPresetBlockStateBits(level, chunkSectionIndex + chunk.getMinSection() << 4);
            } else {
                BlockState[] presetBlockStates = (BlockState[])chunkPacketInfoAntiXray.getPresetValues(chunkSectionIndex);
                for (int i = 0; i < presetBlockStateBits.length; ++i) {
                    presetBlockStateBits[i] = chunkPacketInfoAntiXray.getPalette(chunkSectionIndex).idFor((Object)presetBlockStates[i]);
                }
            }
            bitStorageWriter.setIndex(chunkPacketInfoAntiXray.getIndex(chunkSectionIndex));
            if (chunkSectionIndex == 0 || !chunkPacketInfoAntiXray.isWritten(chunkSectionIndex - 1) || chunkPacketInfoAntiXray.getPresetValues(chunkSectionIndex - 1) == null) {
                bitStorageReader.setBits(chunkPacketInfoAntiXray.getBits(chunkSectionIndex));
                bitStorageReader.setIndex(chunkPacketInfoAntiXray.getIndex(chunkSectionIndex));
                this.readPalette(chunkPacketInfoAntiXray.getPalette(chunkSectionIndex), solid, this.solidGlobal);
                this.readPalette(chunkPacketInfoAntiXray.getPalette(chunkSectionIndex), obfuscate, this.obfuscateGlobal);
                LevelChunkSection belowChunkSection = null;
                boolean skipFirstLayer = chunkSectionIndex == 0 || (belowChunkSection = chunk.getSections()[chunkSectionIndex - 1]) == EMPTY_SECTION;
                for (z = 0; z < 16; ++z) {
                    for (x = 0; x < 16; ++x) {
                        current[z][x] = true;
                        next[z][x] = skipFirstLayer || this.isTransparent(belowChunkSection, x, 15, z);
                    }
                }
                bitStorageWriter.setBits(0);
                this.obfuscateLayer(-1, bitStorageReader, bitStorageWriter, solid, obfuscate, presetBlockStateBits, current, next, nextNext, this.emptyNearbyChunkSections, this.layerIntSupplier(numberOfBlocks));
            }
            bitStorageWriter.setBits(chunkPacketInfoAntiXray.getBits(chunkSectionIndex));
            nearbyChunkSections[0] = chunkPacketInfoAntiXray.getNearbyChunks()[0] == null ? EMPTY_SECTION : chunkPacketInfoAntiXray.getNearbyChunks()[0].getSections()[chunkSectionIndex];
            nearbyChunkSections[1] = chunkPacketInfoAntiXray.getNearbyChunks()[1] == null ? EMPTY_SECTION : chunkPacketInfoAntiXray.getNearbyChunks()[1].getSections()[chunkSectionIndex];
            nearbyChunkSections[2] = chunkPacketInfoAntiXray.getNearbyChunks()[2] == null ? EMPTY_SECTION : chunkPacketInfoAntiXray.getNearbyChunks()[2].getSections()[chunkSectionIndex];
            nearbyChunkSections[3] = chunkPacketInfoAntiXray.getNearbyChunks()[3] == null ? EMPTY_SECTION : chunkPacketInfoAntiXray.getNearbyChunks()[3].getSections()[chunkSectionIndex];
            for (int y = 0; y < 15; ++y) {
                boolean[][] temp = current;
                current = next;
                next = nextNext;
                nextNext = temp;
                this.obfuscateLayer(y, bitStorageReader, bitStorageWriter, solid, obfuscate, presetBlockStateBits, current, next, nextNext, nearbyChunkSections, this.layerIntSupplier(numberOfBlocks));
            }
            if (chunkSectionIndex == maxChunkSectionIndex || !chunkPacketInfoAntiXray.isWritten(chunkSectionIndex + 1) || chunkPacketInfoAntiXray.getPresetValues(chunkSectionIndex + 1) == null) {
                LevelChunkSection aboveChunkSection;
                if (chunkSectionIndex != chunk.getSectionsCount() - 1 && (aboveChunkSection = chunk.getSections()[chunkSectionIndex + 1]) != EMPTY_SECTION) {
                    boolean[][] temp = current;
                    current = next;
                    next = nextNext;
                    nextNext = temp;
                    for (z = 0; z < 16; ++z) {
                        for (x = 0; x < 16; ++x) {
                            if (!this.isTransparent(aboveChunkSection, x, 0, z)) continue;
                            current[z][x] = true;
                        }
                    }
                    bitStorageReader.setBits(0);
                    solid[0] = true;
                    this.obfuscateLayer(15, bitStorageReader, bitStorageWriter, solid, obfuscate, presetBlockStateBits, current, next, nextNext, nearbyChunkSections, this.layerIntSupplier(numberOfBlocks));
                }
            } else {
                bitStorageReader.setBits(chunkPacketInfoAntiXray.getBits(chunkSectionIndex + 1));
                bitStorageReader.setIndex(chunkPacketInfoAntiXray.getIndex(chunkSectionIndex + 1));
                this.readPalette(chunkPacketInfoAntiXray.getPalette(chunkSectionIndex + 1), solid, this.solidGlobal);
                this.readPalette(chunkPacketInfoAntiXray.getPalette(chunkSectionIndex + 1), obfuscate, this.obfuscateGlobal);
                boolean[][] temp = current;
                current = next;
                next = nextNext;
                nextNext = temp;
                this.obfuscateLayer(15, bitStorageReader, bitStorageWriter, solid, obfuscate, presetBlockStateBits, current, next, nextNext, nearbyChunkSections, this.layerIntSupplier(numberOfBlocks));
            }
            bitStorageWriter.flush();
        }
        chunkPacketInfoAntiXray.getChunkPacket().antixray$setReady(true);
    }

    private void obfuscateLayer(int y, BitStorageReader bitStorageReader, BitStorageWriter bitStorageWriter, boolean[] solid, boolean[] obfuscate, int[] presetBlockStateBits, boolean[][] current, boolean[][] next, boolean[][] nextNext, LevelChunkSection[] nearbyChunkSections, IntSupplier random) {
        for (int z = 0; z <= 15; ++z) {
            for (int x = 0; x <= 15; ++x) {
                int bits = bitStorageReader.read();
                nextNext[z][x] = !solid[bits];
                if (nextNext[z][x]) {
                    bitStorageWriter.skip();
                    if (x > 0) {
                        next[z][x - 1] = true;
                    }
                    if (x < 15) {
                        next[z][x + 1] = true;
                    }
                    if (z > 0) {
                        next[z - 1][x] = true;
                    }
                    if (z < 15) {
                        next[z + 1][x] = true;
                    }
                } else {
                    boolean posZ;
                    boolean negX = x == 0 && this.isTransparent(nearbyChunkSections[0], 15, y, z);
                    boolean posX = x == 15 && this.isTransparent(nearbyChunkSections[1], 0, y, z);
                    boolean negZ = z == 0 && this.isTransparent(nearbyChunkSections[2], x, y, 15);
                    boolean bl = posZ = z == 15 && this.isTransparent(nearbyChunkSections[3], x, y, 0);
                    if (current[z][x] || negX || posX || negZ || posZ) {
                        bitStorageWriter.skip();
                    } else {
                        bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
                    }
                }
                if (obfuscate[bits]) continue;
                next[z][x] = true;
            }
        }
    }

    private boolean isTransparent(LevelChunkSection chunkSection, int x, int y, int z) {
        if (chunkSection == EMPTY_SECTION) {
            return true;
        }
        try {
            return !this.solidGlobal.getOrDefault((Object)chunkSection.getBlockState(x, y, z), false);
        }
        catch (MissingPaletteEntryException e) {
            return true;
        }
    }

    private void readPalette(Palette<BlockState> palette, boolean[] temp, Object2BooleanOpenHashMap<BlockState> global) {
        try {
            for (int i = 0; i < palette.getSize(); ++i) {
                temp[i] = global.getOrDefault(palette.valueFor(i), false);
            }
        }
        catch (MissingPaletteEntryException missingPaletteEntryException) {
            // empty catch block
        }
    }

    public IntSupplier layerIntSupplier(final int numberOfBlocks) {
        return numberOfBlocks == 1 ? () -> 0 : new IntSupplier(){
            private int state;
            {
                while ((this.state = ThreadLocalRandom.current().nextInt()) == 0) {
                }
            }

            @Override
            public int getAsInt() {
                this.state ^= this.state << 13;
                this.state ^= this.state >>> 17;
                this.state ^= this.state << 5;
                return (int)(Integer.toUnsignedLong(this.state) * (long)numberOfBlocks >>> 32);
            }
        };
    }

    private static boolean isSolid(EmptyLevelChunk emptyChunk, BlockState blockState, boolean lavaObscures) {
        return blockState.isCollisionShapeFullBlock((BlockGetter)emptyChunk, BlockPos.ZERO) && blockState.canOcclude() || lavaObscures && blockState == Blocks.LAVA.defaultBlockState();
    }
}

