@echo off
setlocal enabledelayedexpansion

:: Set Minecraft folder
set MC_FOLDER=%APPDATA%\.minecraft

:: Get timestamp
for /f "tokens=2 delims==" %%I in ('"wmic os get localdatetime /value"') do set datetime=%%I
set timestamp=%datetime:~0,4%-%datetime:~4,2%-%datetime:~6,2%_%datetime:~8,2%-%datetime:~10,2%

echo ====================================
echo   Minecraft Modpack Installer
echo ====================================
echo.

:: Backup existing folders
echo Backing up existing folders if they exist...
cd /d "%MC_FOLDER%"

if exist mods (
    ren mods mods_backup_%timestamp%
    echo Backed up 'mods' to 'mods_backup_%timestamp%'
)

if exist config (
    ren config config_backup_%timestamp%
    echo Backed up 'config' to 'config_backup_%timestamp%'
)

if exist shaderpacks (
    ren shaderpacks shaderpacks_backup_%timestamp%
    echo Backed up 'shaderpacks' to 'shaderpacks_backup_%timestamp%'
)

if exist resourcepacks (
    ren resourcepacks resourcepacks_backup_%timestamp%
    echo Backed up 'resourcepacks' to 'resourcepacks_backup_%timestamp%'
)

:: Copy new modpack files
echo.
echo Installing new modpack files...
xcopy /E /I /Y "%~dp0mods" "%MC_FOLDER%\mods"
xcopy /E /I /Y "%~dp0config" "%MC_FOLDER%\config"
xcopy /E /I /Y "%~dp0shaderpacks" "%MC_FOLDER%\shaderpacks"
xcopy /E /I /Y "%~dp0resourcepacks" "%MC_FOLDER%\resourcepacks"

echo.
echo Installation complete!
echo Your old folders were backed up with today's date.
echo.
pause
